/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.BlobStorageEventType;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventGridDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class EventGridConnectionProperties {
    @JsonProperty(value="storageAccountResourceId", required=true)
    private String storageAccountResourceId;
    @JsonProperty(value="eventGridResourceId")
    private String eventGridResourceId;
    @JsonProperty(value="eventHubResourceId", required=true)
    private String eventHubResourceId;
    @JsonProperty(value="consumerGroup", required=true)
    private String consumerGroup;
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="mappingRuleName")
    private String mappingRuleName;
    @JsonProperty(value="dataFormat")
    private EventGridDataFormat dataFormat;
    @JsonProperty(value="ignoreFirstRecord")
    private Boolean ignoreFirstRecord;
    @JsonProperty(value="blobStorageEventType")
    private BlobStorageEventType blobStorageEventType;
    @JsonProperty(value="managedIdentityResourceId")
    private String managedIdentityResourceId;
    @JsonProperty(value="managedIdentityObjectId", access=JsonProperty.Access.WRITE_ONLY)
    private String managedIdentityObjectId;
    @JsonProperty(value="databaseRouting")
    private DatabaseRouting databaseRouting;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(EventGridConnectionProperties.class);

    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    public EventGridConnectionProperties withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    public String eventGridResourceId() {
        return this.eventGridResourceId;
    }

    public EventGridConnectionProperties withEventGridResourceId(String eventGridResourceId) {
        this.eventGridResourceId = eventGridResourceId;
        return this;
    }

    public String eventHubResourceId() {
        return this.eventHubResourceId;
    }

    public EventGridConnectionProperties withEventHubResourceId(String eventHubResourceId) {
        this.eventHubResourceId = eventHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public EventGridConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public EventGridConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public EventGridConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public EventGridDataFormat dataFormat() {
        return this.dataFormat;
    }

    public EventGridConnectionProperties withDataFormat(EventGridDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public Boolean ignoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public EventGridConnectionProperties withIgnoreFirstRecord(Boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
        return this;
    }

    public BlobStorageEventType blobStorageEventType() {
        return this.blobStorageEventType;
    }

    public EventGridConnectionProperties withBlobStorageEventType(BlobStorageEventType blobStorageEventType) {
        this.blobStorageEventType = blobStorageEventType;
        return this;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public EventGridConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public EventGridConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.storageAccountResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageAccountResourceId in model EventGridConnectionProperties"));
        }
        if (this.eventHubResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property eventHubResourceId in model EventGridConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model EventGridConnectionProperties"));
        }
    }
}

