/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.Compression;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventHubConnectionProperties {
    @JsonProperty(value="eventHubResourceId", required=true)
    private String eventHubResourceId;
    @JsonProperty(value="consumerGroup", required=true)
    private String consumerGroup;
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="mappingRuleName")
    private String mappingRuleName;
    @JsonProperty(value="dataFormat")
    private EventHubDataFormat dataFormat;
    @JsonProperty(value="eventSystemProperties")
    private List<String> eventSystemProperties;
    @JsonProperty(value="compression")
    private Compression compression;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="managedIdentityResourceId")
    private String managedIdentityResourceId;
    @JsonProperty(value="managedIdentityObjectId", access=JsonProperty.Access.WRITE_ONLY)
    private String managedIdentityObjectId;
    @JsonProperty(value="databaseRouting")
    private DatabaseRouting databaseRouting;
    @JsonProperty(value="retrievalStartDate")
    private OffsetDateTime retrievalStartDate;
    private static final ClientLogger LOGGER = new ClientLogger(EventHubConnectionProperties.class);

    public String eventHubResourceId() {
        return this.eventHubResourceId;
    }

    public EventHubConnectionProperties withEventHubResourceId(String eventHubResourceId) {
        this.eventHubResourceId = eventHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public EventHubConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public EventHubConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public EventHubConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public EventHubDataFormat dataFormat() {
        return this.dataFormat;
    }

    public EventHubConnectionProperties withDataFormat(EventHubDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.eventSystemProperties;
    }

    public EventHubConnectionProperties withEventSystemProperties(List<String> eventSystemProperties) {
        this.eventSystemProperties = eventSystemProperties;
        return this;
    }

    public Compression compression() {
        return this.compression;
    }

    public EventHubConnectionProperties withCompression(Compression compression) {
        this.compression = compression;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public EventHubConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public EventHubConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public EventHubConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public void validate() {
        if (this.eventHubResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property eventHubResourceId in model EventHubConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model EventHubConnectionProperties"));
        }
    }
}

