/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.IotHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class IotHubConnectionProperties {
    @JsonProperty(value="iotHubResourceId", required=true)
    private String iotHubResourceId;
    @JsonProperty(value="consumerGroup", required=true)
    private String consumerGroup;
    @JsonProperty(value="tableName")
    private String tableName;
    @JsonProperty(value="mappingRuleName")
    private String mappingRuleName;
    @JsonProperty(value="dataFormat")
    private IotHubDataFormat dataFormat;
    @JsonProperty(value="eventSystemProperties")
    private List<String> eventSystemProperties;
    @JsonProperty(value="sharedAccessPolicyName", required=true)
    private String sharedAccessPolicyName;
    @JsonProperty(value="databaseRouting")
    private DatabaseRouting databaseRouting;
    @JsonProperty(value="retrievalStartDate")
    private OffsetDateTime retrievalStartDate;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubConnectionProperties.class);

    public String iotHubResourceId() {
        return this.iotHubResourceId;
    }

    public IotHubConnectionProperties withIotHubResourceId(String iotHubResourceId) {
        this.iotHubResourceId = iotHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public IotHubConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public IotHubConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public IotHubConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public IotHubDataFormat dataFormat() {
        return this.dataFormat;
    }

    public IotHubConnectionProperties withDataFormat(IotHubDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.eventSystemProperties;
    }

    public IotHubConnectionProperties withEventSystemProperties(List<String> eventSystemProperties) {
        this.eventSystemProperties = eventSystemProperties;
        return this;
    }

    public String sharedAccessPolicyName() {
        return this.sharedAccessPolicyName;
    }

    public IotHubConnectionProperties withSharedAccessPolicyName(String sharedAccessPolicyName) {
        this.sharedAccessPolicyName = sharedAccessPolicyName;
        return this;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public IotHubConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public IotHubConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.iotHubResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property iotHubResourceId in model IotHubConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model IotHubConnectionProperties"));
        }
        if (this.sharedAccessPolicyName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sharedAccessPolicyName in model IotHubConnectionProperties"));
        }
    }
}

