/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.Language;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SandboxCustomImageProperties {
    @JsonProperty(value="language", required=true)
    private Language language;
    @JsonProperty(value="languageVersion", required=true)
    private String languageVersion;
    @JsonProperty(value="requirementsFileContent")
    private String requirementsFileContent;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SandboxCustomImageProperties.class);

    public Language language() {
        return this.language;
    }

    public SandboxCustomImageProperties withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public String languageVersion() {
        return this.languageVersion;
    }

    public SandboxCustomImageProperties withLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
        return this;
    }

    public String requirementsFileContent() {
        return this.requirementsFileContent;
    }

    public SandboxCustomImageProperties withRequirementsFileContent(String requirementsFileContent) {
        this.requirementsFileContent = requirementsFileContent;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.language() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property language in model SandboxCustomImageProperties"));
        }
        if (this.languageVersion() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property languageVersion in model SandboxCustomImageProperties"));
        }
    }
}

