/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.AttachedDatabaseConfigurationInner;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.AttachedDatabaseConfiguration;
import com.azure.resourcemanager.kusto.models.DefaultPrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.util.Collections;
import java.util.List;

public final class AttachedDatabaseConfigurationImpl
implements AttachedDatabaseConfiguration,
AttachedDatabaseConfiguration.Definition,
AttachedDatabaseConfiguration.Update {
    private AttachedDatabaseConfigurationInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String attachedDatabaseConfigurationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String databaseName() {
        return this.innerModel().databaseName();
    }

    @Override
    public String clusterResourceId() {
        return this.innerModel().clusterResourceId();
    }

    @Override
    public List<String> attachedDatabaseNames() {
        List<String> inner = this.innerModel().attachedDatabaseNames();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DefaultPrincipalsModificationKind defaultPrincipalsModificationKind() {
        return this.innerModel().defaultPrincipalsModificationKind();
    }

    @Override
    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.innerModel().tableLevelSharingProperties();
    }

    @Override
    public String databaseNameOverride() {
        return this.innerModel().databaseNameOverride();
    }

    @Override
    public String databaseNamePrefix() {
        return this.innerModel().databaseNamePrefix();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AttachedDatabaseConfigurationInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public AttachedDatabaseConfiguration create() {
        this.innerObject = this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AttachedDatabaseConfiguration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, this.innerModel(), context);
        return this;
    }

    AttachedDatabaseConfigurationImpl(String name, KustoManager serviceManager) {
        this.innerObject = new AttachedDatabaseConfigurationInner();
        this.serviceManager = serviceManager;
        this.attachedDatabaseConfigurationName = name;
    }

    @Override
    public AttachedDatabaseConfigurationImpl update() {
        return this;
    }

    @Override
    public AttachedDatabaseConfiguration apply() {
        this.innerObject = this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AttachedDatabaseConfiguration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().createOrUpdate(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, this.innerModel(), context);
        return this;
    }

    AttachedDatabaseConfigurationImpl(AttachedDatabaseConfigurationInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
        this.attachedDatabaseConfigurationName = Utils.getValueFromIdByName(innerObject.id(), "attachedDatabaseConfigurations");
    }

    @Override
    public AttachedDatabaseConfiguration refresh() {
        this.innerObject = (AttachedDatabaseConfigurationInner)((Object)this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().getWithResponse(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AttachedDatabaseConfiguration refresh(Context context) {
        this.innerObject = (AttachedDatabaseConfigurationInner)((Object)this.serviceManager.serviceClient().getAttachedDatabaseConfigurations().getWithResponse(this.resourceGroupName, this.clusterName, this.attachedDatabaseConfigurationName, context).getValue());
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withDatabaseName(String databaseName) {
        this.innerModel().withDatabaseName(databaseName);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withClusterResourceId(String clusterResourceId) {
        this.innerModel().withClusterResourceId(clusterResourceId);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind defaultPrincipalsModificationKind) {
        this.innerModel().withDefaultPrincipalsModificationKind(defaultPrincipalsModificationKind);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withTableLevelSharingProperties(TableLevelSharingProperties tableLevelSharingProperties) {
        this.innerModel().withTableLevelSharingProperties(tableLevelSharingProperties);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withDatabaseNameOverride(String databaseNameOverride) {
        this.innerModel().withDatabaseNameOverride(databaseNameOverride);
        return this;
    }

    @Override
    public AttachedDatabaseConfigurationImpl withDatabaseNamePrefix(String databaseNamePrefix) {
        this.innerModel().withDatabaseNamePrefix(databaseNamePrefix);
        return this;
    }
}

