/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.AttachedDatabaseConfigurationsClient;
import com.azure.resourcemanager.kusto.fluent.models.AttachedDatabaseConfigurationInner;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.implementation.AttachedDatabaseConfigurationImpl;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.AttachedDatabaseConfiguration;
import com.azure.resourcemanager.kusto.models.AttachedDatabaseConfigurations;
import com.azure.resourcemanager.kusto.models.AttachedDatabaseConfigurationsCheckNameRequest;
import com.azure.resourcemanager.kusto.models.CheckNameResult;

public final class AttachedDatabaseConfigurationsImpl
implements AttachedDatabaseConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(AttachedDatabaseConfigurationsImpl.class);
    private final AttachedDatabaseConfigurationsClient innerClient;
    private final KustoManager serviceManager;

    public AttachedDatabaseConfigurationsImpl(AttachedDatabaseConfigurationsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, AttachedDatabaseConfigurationsCheckNameRequest resourceName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, AttachedDatabaseConfigurationsCheckNameRequest resourceName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, resourceName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AttachedDatabaseConfiguration> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<AttachedDatabaseConfigurationInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return Utils.mapPage(inner, inner1 -> new AttachedDatabaseConfigurationImpl((AttachedDatabaseConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<AttachedDatabaseConfiguration> listByCluster(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<AttachedDatabaseConfigurationInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, context);
        return Utils.mapPage(inner, inner1 -> new AttachedDatabaseConfigurationImpl((AttachedDatabaseConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<AttachedDatabaseConfiguration> getWithResponse(String resourceGroupName, String clusterName, String attachedDatabaseConfigurationName, Context context) {
        Response<AttachedDatabaseConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, attachedDatabaseConfigurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AttachedDatabaseConfigurationImpl((AttachedDatabaseConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public AttachedDatabaseConfiguration get(String resourceGroupName, String clusterName, String attachedDatabaseConfigurationName) {
        AttachedDatabaseConfigurationInner inner = this.serviceClient().get(resourceGroupName, clusterName, attachedDatabaseConfigurationName);
        if (inner != null) {
            return new AttachedDatabaseConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String attachedDatabaseConfigurationName) {
        this.serviceClient().delete(resourceGroupName, clusterName, attachedDatabaseConfigurationName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String attachedDatabaseConfigurationName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, attachedDatabaseConfigurationName, context);
    }

    @Override
    public AttachedDatabaseConfiguration getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String attachedDatabaseConfigurationName = Utils.getValueFromIdByName(id, "attachedDatabaseConfigurations");
        if (attachedDatabaseConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachedDatabaseConfigurations'.", id)));
        }
        return (AttachedDatabaseConfiguration)this.getWithResponse(resourceGroupName, clusterName, attachedDatabaseConfigurationName, Context.NONE).getValue();
    }

    @Override
    public Response<AttachedDatabaseConfiguration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String attachedDatabaseConfigurationName = Utils.getValueFromIdByName(id, "attachedDatabaseConfigurations");
        if (attachedDatabaseConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachedDatabaseConfigurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, attachedDatabaseConfigurationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String attachedDatabaseConfigurationName = Utils.getValueFromIdByName(id, "attachedDatabaseConfigurations");
        if (attachedDatabaseConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachedDatabaseConfigurations'.", id)));
        }
        this.delete(resourceGroupName, clusterName, attachedDatabaseConfigurationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String attachedDatabaseConfigurationName = Utils.getValueFromIdByName(id, "attachedDatabaseConfigurations");
        if (attachedDatabaseConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'attachedDatabaseConfigurations'.", id)));
        }
        this.delete(resourceGroupName, clusterName, attachedDatabaseConfigurationName, context);
    }

    private AttachedDatabaseConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public AttachedDatabaseConfigurationImpl define(String name) {
        return new AttachedDatabaseConfigurationImpl(name, this.manager());
    }
}

