/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.ClusterInner;
import com.azure.resourcemanager.kusto.fluent.models.FollowerDatabaseDefinitionInner;
import com.azure.resourcemanager.kusto.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.kusto.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.AcceptedAudiences;
import com.azure.resourcemanager.kusto.models.AzureSku;
import com.azure.resourcemanager.kusto.models.Cluster;
import com.azure.resourcemanager.kusto.models.ClusterMigrateRequest;
import com.azure.resourcemanager.kusto.models.ClusterNetworkAccessFlag;
import com.azure.resourcemanager.kusto.models.ClusterUpdate;
import com.azure.resourcemanager.kusto.models.DiagnoseVirtualNetworkResult;
import com.azure.resourcemanager.kusto.models.EngineType;
import com.azure.resourcemanager.kusto.models.FollowerDatabaseDefinition;
import com.azure.resourcemanager.kusto.models.Identity;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.LanguageExtension;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.MigrationClusterProperties;
import com.azure.resourcemanager.kusto.models.OptimizedAutoscale;
import com.azure.resourcemanager.kusto.models.PrivateEndpointConnection;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.PublicIpType;
import com.azure.resourcemanager.kusto.models.PublicNetworkAccess;
import com.azure.resourcemanager.kusto.models.State;
import com.azure.resourcemanager.kusto.models.TrustedExternalTenant;
import com.azure.resourcemanager.kusto.models.VirtualNetworkConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ClusterImpl
implements Cluster,
Cluster.Definition,
Cluster.Update {
    private ClusterInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private ClusterUpdate updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public AzureSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Identity identity() {
        return this.innerModel().identity();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public State state() {
        return this.innerModel().state();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String uri() {
        return this.innerModel().uri();
    }

    @Override
    public String dataIngestionUri() {
        return this.innerModel().dataIngestionUri();
    }

    @Override
    public String stateReason() {
        return this.innerModel().stateReason();
    }

    @Override
    public List<TrustedExternalTenant> trustedExternalTenants() {
        List<TrustedExternalTenant> inner = this.innerModel().trustedExternalTenants();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public OptimizedAutoscale optimizedAutoscale() {
        return this.innerModel().optimizedAutoscale();
    }

    @Override
    public Boolean enableDiskEncryption() {
        return this.innerModel().enableDiskEncryption();
    }

    @Override
    public Boolean enableStreamingIngest() {
        return this.innerModel().enableStreamingIngest();
    }

    @Override
    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.innerModel().virtualNetworkConfiguration();
    }

    @Override
    public KeyVaultProperties keyVaultProperties() {
        return this.innerModel().keyVaultProperties();
    }

    @Override
    public Boolean enablePurge() {
        return this.innerModel().enablePurge();
    }

    @Override
    public LanguageExtensionsList languageExtensions() {
        return this.innerModel().languageExtensions();
    }

    @Override
    public Boolean enableDoubleEncryption() {
        return this.innerModel().enableDoubleEncryption();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<String> allowedIpRangeList() {
        List<String> inner = this.innerModel().allowedIpRangeList();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public EngineType engineType() {
        return this.innerModel().engineType();
    }

    @Override
    public List<AcceptedAudiences> acceptedAudiences() {
        List<AcceptedAudiences> inner = this.innerModel().acceptedAudiences();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean enableAutoStop() {
        return this.innerModel().enableAutoStop();
    }

    @Override
    public ClusterNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.innerModel().restrictOutboundNetworkAccess();
    }

    @Override
    public List<String> allowedFqdnList() {
        List<String> inner = this.innerModel().allowedFqdnList();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public PublicIpType publicIpType() {
        return this.innerModel().publicIpType();
    }

    @Override
    public String virtualClusterGraduationProperties() {
        return this.innerModel().virtualClusterGraduationProperties();
    }

    @Override
    public List<PrivateEndpointConnection> privateEndpointConnections() {
        List<PrivateEndpointConnectionInner> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner.stream().map(inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager())).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @Override
    public MigrationClusterProperties migrationCluster() {
        return this.innerModel().migrationCluster();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Cluster create() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public Cluster create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().createOrUpdate(this.resourceGroupName, this.clusterName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    ClusterImpl(String name, KustoManager serviceManager) {
        this.innerObject = new ClusterInner();
        this.serviceManager = serviceManager;
        this.clusterName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public ClusterImpl update() {
        this.updateIfMatch = null;
        this.updateParameters = new ClusterUpdate();
        return this;
    }

    @Override
    public Cluster apply() {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateParameters, this.updateIfMatch, Context.NONE);
        return this;
    }

    @Override
    public Cluster apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusters().update(this.resourceGroupName, this.clusterName, this.updateParameters, this.updateIfMatch, context);
        return this;
    }

    ClusterImpl(ClusterInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
    }

    @Override
    public Cluster refresh() {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Cluster refresh(Context context) {
        this.innerObject = (ClusterInner)((Object)this.serviceManager.serviceClient().getClusters().getByResourceGroupWithResponse(this.resourceGroupName, this.clusterName, context).getValue());
        return this;
    }

    @Override
    public void stop() {
        this.serviceManager.clusters().stop(this.resourceGroupName, this.clusterName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.clusters().stop(this.resourceGroupName, this.clusterName, context);
    }

    @Override
    public void start() {
        this.serviceManager.clusters().start(this.resourceGroupName, this.clusterName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.clusters().start(this.resourceGroupName, this.clusterName, context);
    }

    @Override
    public void migrate(ClusterMigrateRequest clusterMigrateRequest) {
        this.serviceManager.clusters().migrate(this.resourceGroupName, this.clusterName, clusterMigrateRequest);
    }

    @Override
    public void migrate(ClusterMigrateRequest clusterMigrateRequest, Context context) {
        this.serviceManager.clusters().migrate(this.resourceGroupName, this.clusterName, clusterMigrateRequest, context);
    }

    @Override
    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases() {
        return this.serviceManager.clusters().listFollowerDatabases(this.resourceGroupName, this.clusterName);
    }

    @Override
    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases(Context context) {
        return this.serviceManager.clusters().listFollowerDatabases(this.resourceGroupName, this.clusterName, context);
    }

    @Override
    public void detachFollowerDatabases(FollowerDatabaseDefinitionInner followerDatabaseToRemove) {
        this.serviceManager.clusters().detachFollowerDatabases(this.resourceGroupName, this.clusterName, followerDatabaseToRemove);
    }

    @Override
    public void detachFollowerDatabases(FollowerDatabaseDefinitionInner followerDatabaseToRemove, Context context) {
        this.serviceManager.clusters().detachFollowerDatabases(this.resourceGroupName, this.clusterName, followerDatabaseToRemove, context);
    }

    @Override
    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork() {
        return this.serviceManager.clusters().diagnoseVirtualNetwork(this.resourceGroupName, this.clusterName);
    }

    @Override
    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork(Context context) {
        return this.serviceManager.clusters().diagnoseVirtualNetwork(this.resourceGroupName, this.clusterName, context);
    }

    @Override
    public PagedIterable<LanguageExtension> listLanguageExtensions() {
        return this.serviceManager.clusters().listLanguageExtensions(this.resourceGroupName, this.clusterName);
    }

    @Override
    public PagedIterable<LanguageExtension> listLanguageExtensions(Context context) {
        return this.serviceManager.clusters().listLanguageExtensions(this.resourceGroupName, this.clusterName, context);
    }

    @Override
    public void addLanguageExtensions(LanguageExtensionsList languageExtensionsToAdd) {
        this.serviceManager.clusters().addLanguageExtensions(this.resourceGroupName, this.clusterName, languageExtensionsToAdd);
    }

    @Override
    public void addLanguageExtensions(LanguageExtensionsList languageExtensionsToAdd, Context context) {
        this.serviceManager.clusters().addLanguageExtensions(this.resourceGroupName, this.clusterName, languageExtensionsToAdd, context);
    }

    @Override
    public void removeLanguageExtensions(LanguageExtensionsList languageExtensionsToRemove) {
        this.serviceManager.clusters().removeLanguageExtensions(this.resourceGroupName, this.clusterName, languageExtensionsToRemove);
    }

    @Override
    public void removeLanguageExtensions(LanguageExtensionsList languageExtensionsToRemove, Context context) {
        this.serviceManager.clusters().removeLanguageExtensions(this.resourceGroupName, this.clusterName, languageExtensionsToRemove, context);
    }

    @Override
    public ClusterImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ClusterImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ClusterImpl withSku(AzureSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ClusterImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ClusterImpl withZones(List<String> zones) {
        if (this.isInCreateMode()) {
            this.innerModel().withZones(zones);
            return this;
        }
        this.updateParameters.withZones(zones);
        return this;
    }

    @Override
    public ClusterImpl withIdentity(Identity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ClusterImpl withTrustedExternalTenants(List<TrustedExternalTenant> trustedExternalTenants) {
        if (this.isInCreateMode()) {
            this.innerModel().withTrustedExternalTenants(trustedExternalTenants);
            return this;
        }
        this.updateParameters.withTrustedExternalTenants(trustedExternalTenants);
        return this;
    }

    @Override
    public ClusterImpl withOptimizedAutoscale(OptimizedAutoscale optimizedAutoscale) {
        if (this.isInCreateMode()) {
            this.innerModel().withOptimizedAutoscale(optimizedAutoscale);
            return this;
        }
        this.updateParameters.withOptimizedAutoscale(optimizedAutoscale);
        return this;
    }

    @Override
    public ClusterImpl withEnableDiskEncryption(Boolean enableDiskEncryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableDiskEncryption(enableDiskEncryption);
            return this;
        }
        this.updateParameters.withEnableDiskEncryption(enableDiskEncryption);
        return this;
    }

    @Override
    public ClusterImpl withEnableStreamingIngest(Boolean enableStreamingIngest) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableStreamingIngest(enableStreamingIngest);
            return this;
        }
        this.updateParameters.withEnableStreamingIngest(enableStreamingIngest);
        return this;
    }

    @Override
    public ClusterImpl withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withVirtualNetworkConfiguration(virtualNetworkConfiguration);
            return this;
        }
        this.updateParameters.withVirtualNetworkConfiguration(virtualNetworkConfiguration);
        return this;
    }

    @Override
    public ClusterImpl withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.isInCreateMode()) {
            this.innerModel().withKeyVaultProperties(keyVaultProperties);
            return this;
        }
        this.updateParameters.withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    @Override
    public ClusterImpl withEnablePurge(Boolean enablePurge) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnablePurge(enablePurge);
            return this;
        }
        this.updateParameters.withEnablePurge(enablePurge);
        return this;
    }

    @Override
    public ClusterImpl withLanguageExtensions(LanguageExtensionsList languageExtensions) {
        if (this.isInCreateMode()) {
            this.innerModel().withLanguageExtensions(languageExtensions);
            return this;
        }
        this.updateParameters.withLanguageExtensions(languageExtensions);
        return this;
    }

    @Override
    public ClusterImpl withEnableDoubleEncryption(Boolean enableDoubleEncryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableDoubleEncryption(enableDoubleEncryption);
            return this;
        }
        this.updateParameters.withEnableDoubleEncryption(enableDoubleEncryption);
        return this;
    }

    @Override
    public ClusterImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ClusterImpl withAllowedIpRangeList(List<String> allowedIpRangeList) {
        if (this.isInCreateMode()) {
            this.innerModel().withAllowedIpRangeList(allowedIpRangeList);
            return this;
        }
        this.updateParameters.withAllowedIpRangeList(allowedIpRangeList);
        return this;
    }

    @Override
    public ClusterImpl withEngineType(EngineType engineType) {
        if (this.isInCreateMode()) {
            this.innerModel().withEngineType(engineType);
            return this;
        }
        this.updateParameters.withEngineType(engineType);
        return this;
    }

    @Override
    public ClusterImpl withAcceptedAudiences(List<AcceptedAudiences> acceptedAudiences) {
        if (this.isInCreateMode()) {
            this.innerModel().withAcceptedAudiences(acceptedAudiences);
            return this;
        }
        this.updateParameters.withAcceptedAudiences(acceptedAudiences);
        return this;
    }

    @Override
    public ClusterImpl withEnableAutoStop(Boolean enableAutoStop) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableAutoStop(enableAutoStop);
            return this;
        }
        this.updateParameters.withEnableAutoStop(enableAutoStop);
        return this;
    }

    @Override
    public ClusterImpl withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag restrictOutboundNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
            return this;
        }
        this.updateParameters.withRestrictOutboundNetworkAccess(restrictOutboundNetworkAccess);
        return this;
    }

    @Override
    public ClusterImpl withAllowedFqdnList(List<String> allowedFqdnList) {
        if (this.isInCreateMode()) {
            this.innerModel().withAllowedFqdnList(allowedFqdnList);
            return this;
        }
        this.updateParameters.withAllowedFqdnList(allowedFqdnList);
        return this;
    }

    @Override
    public ClusterImpl withPublicIpType(PublicIpType publicIpType) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicIpType(publicIpType);
            return this;
        }
        this.updateParameters.withPublicIpType(publicIpType);
        return this;
    }

    @Override
    public ClusterImpl withVirtualClusterGraduationProperties(String virtualClusterGraduationProperties) {
        this.innerModel().withVirtualClusterGraduationProperties(virtualClusterGraduationProperties);
        return this;
    }

    @Override
    public ClusterImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public ClusterImpl withIfNoneMatch(String ifNoneMatch) {
        this.createIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

