/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.ClusterPrincipalAssignmentInner;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalAssignment;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalRole;
import com.azure.resourcemanager.kusto.models.PrincipalType;
import com.azure.resourcemanager.kusto.models.ProvisioningState;

public final class ClusterPrincipalAssignmentImpl
implements ClusterPrincipalAssignment,
ClusterPrincipalAssignment.Definition,
ClusterPrincipalAssignment.Update {
    private ClusterPrincipalAssignmentInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String principalAssignmentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String principalId() {
        return this.innerModel().principalId();
    }

    @Override
    public ClusterPrincipalRole role() {
        return this.innerModel().role();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public PrincipalType principalType() {
        return this.innerModel().principalType();
    }

    @Override
    public String tenantName() {
        return this.innerModel().tenantName();
    }

    @Override
    public String principalName() {
        return this.innerModel().principalName();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String aadObjectId() {
        return this.innerModel().aadObjectId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ClusterPrincipalAssignmentInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterPrincipalAssignmentImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public ClusterPrincipalAssignment create() {
        this.innerObject = this.serviceManager.serviceClient().getClusterPrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.principalAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClusterPrincipalAssignment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusterPrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.principalAssignmentName, this.innerModel(), context);
        return this;
    }

    ClusterPrincipalAssignmentImpl(String name, KustoManager serviceManager) {
        this.innerObject = new ClusterPrincipalAssignmentInner();
        this.serviceManager = serviceManager;
        this.principalAssignmentName = name;
    }

    @Override
    public ClusterPrincipalAssignmentImpl update() {
        return this;
    }

    @Override
    public ClusterPrincipalAssignment apply() {
        this.innerObject = this.serviceManager.serviceClient().getClusterPrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.principalAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ClusterPrincipalAssignment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getClusterPrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.principalAssignmentName, this.innerModel(), context);
        return this;
    }

    ClusterPrincipalAssignmentImpl(ClusterPrincipalAssignmentInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
        this.principalAssignmentName = Utils.getValueFromIdByName(innerObject.id(), "principalAssignments");
    }

    @Override
    public ClusterPrincipalAssignment refresh() {
        this.innerObject = (ClusterPrincipalAssignmentInner)((Object)this.serviceManager.serviceClient().getClusterPrincipalAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.principalAssignmentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ClusterPrincipalAssignment refresh(Context context) {
        this.innerObject = (ClusterPrincipalAssignmentInner)((Object)this.serviceManager.serviceClient().getClusterPrincipalAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.principalAssignmentName, context).getValue());
        return this;
    }

    @Override
    public ClusterPrincipalAssignmentImpl withPrincipalId(String principalId) {
        this.innerModel().withPrincipalId(principalId);
        return this;
    }

    @Override
    public ClusterPrincipalAssignmentImpl withRole(ClusterPrincipalRole role) {
        this.innerModel().withRole(role);
        return this;
    }

    @Override
    public ClusterPrincipalAssignmentImpl withTenantId(String tenantId) {
        this.innerModel().withTenantId(tenantId);
        return this;
    }

    @Override
    public ClusterPrincipalAssignmentImpl withPrincipalType(PrincipalType principalType) {
        this.innerModel().withPrincipalType(principalType);
        return this;
    }
}

