/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.kusto.fluent.DataConnectionsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionValidationInner;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionValidationListResultInner;
import com.azure.resourcemanager.kusto.implementation.KustoManagementClientImpl;
import com.azure.resourcemanager.kusto.models.DataConnectionCheckNameRequest;
import com.azure.resourcemanager.kusto.models.DataConnectionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DataConnectionsClientImpl
implements DataConnectionsClient {
    private final DataConnectionsService service;
    private final KustoManagementClientImpl client;

    DataConnectionsClientImpl(KustoManagementClientImpl client) {
        this.service = (DataConnectionsService)RestProxy.create(DataConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataConnectionInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String clusterName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataConnectionListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DataConnectionInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String clusterName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DataConnectionListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataConnectionInner> listByDatabaseAsync(String resourceGroupName, String clusterName, String databaseName) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, clusterName, databaseName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DataConnectionInner> listByDatabaseAsync(String resourceGroupName, String clusterName, String databaseName, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, clusterName, databaseName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataConnectionInner> listByDatabase(String resourceGroupName, String clusterName, String databaseName) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, clusterName, databaseName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataConnectionInner> listByDatabase(String resourceGroupName, String clusterName, String databaseName, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, clusterName, databaseName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> dataConnectionValidationWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.dataConnectionValidation(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> dataConnectionValidationWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.dataConnectionValidation(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionValidationListResultInner>, DataConnectionValidationListResultInner> beginDataConnectionValidationAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.dataConnectionValidationWithResponseAsync(resourceGroupName, clusterName, databaseName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionValidationListResultInner.class), (Type)((Object)DataConnectionValidationListResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionValidationListResultInner>, DataConnectionValidationListResultInner> beginDataConnectionValidationAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.dataConnectionValidationWithResponseAsync(resourceGroupName, clusterName, databaseName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionValidationListResultInner.class), (Type)((Object)DataConnectionValidationListResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionValidationListResultInner>, DataConnectionValidationListResultInner> beginDataConnectionValidation(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters) {
        return this.beginDataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionValidationListResultInner>, DataConnectionValidationListResultInner> beginDataConnectionValidation(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters, Context context) {
        return this.beginDataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionValidationListResultInner> dataConnectionValidationAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters) {
        return this.beginDataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionValidationListResultInner> dataConnectionValidationAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters, Context context) {
        return this.beginDataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionValidationListResultInner dataConnectionValidation(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters) {
        return (DataConnectionValidationListResultInner)this.dataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionValidationListResultInner dataConnectionValidation(String resourceGroupName, String clusterName, String databaseName, DataConnectionValidationInner parameters, Context context) {
        return (DataConnectionValidationListResultInner)this.dataConnectionValidationAsync(resourceGroupName, clusterName, databaseName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionCheckNameRequest dataConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        dataConnectionName.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), dataConnectionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionCheckNameRequest dataConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        dataConnectionName.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), dataConnectionName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckNameResultInner> checkNameAvailabilityAsync(String resourceGroupName, String clusterName, String databaseName, DataConnectionCheckNameRequest dataConnectionName) {
        return this.checkNameAvailabilityWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameResultInner> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, String databaseName, DataConnectionCheckNameRequest dataConnectionName, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameResultInner checkNameAvailability(String resourceGroupName, String clusterName, String databaseName, DataConnectionCheckNameRequest dataConnectionName) {
        return (CheckNameResultInner)this.checkNameAvailabilityWithResponse(resourceGroupName, clusterName, databaseName, dataConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataConnectionInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DataConnectionInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionInner> getAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        return this.getWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DataConnectionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataConnectionInner> getWithResponse(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionInner get(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        return (DataConnectionInner)((Object)this.getWithResponse(resourceGroupName, clusterName, databaseName, dataConnectionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionInner>, DataConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionInner.class), (Type)((Object)DataConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionInner>, DataConnectionInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionInner.class), (Type)((Object)DataConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionInner>, DataConnectionInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionInner>, DataConnectionInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionInner createOrUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return (DataConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionInner createOrUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return (DataConnectionInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionInner>, DataConnectionInner> beginUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionInner.class), (Type)((Object)DataConnectionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataConnectionInner>, DataConnectionInner> beginUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DataConnectionInner.class), (Type)((Object)DataConnectionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionInner>, DataConnectionInner> beginUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataConnectionInner>, DataConnectionInner> beginUpdate(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionInner> updateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DataConnectionInner> updateAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionInner update(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters) {
        return (DataConnectionInner)((Object)this.updateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataConnectionInner update(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, DataConnectionInner parameters, Context context) {
        return (DataConnectionInner)((Object)this.updateAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (dataConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter dataConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, dataConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName) {
        this.deleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String databaseName, String dataConnectionName, Context context) {
        this.deleteAsync(resourceGroupName, clusterName, databaseName, dataConnectionName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KustoManagementClien")
    public static interface DataConnectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataConnectionListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnectionValidation")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> dataConnectionValidation(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") DataConnectionValidationInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameResultInner>> checkNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") DataConnectionCheckNameRequest var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DataConnectionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataConnectionName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataConnectionName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") DataConnectionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataConnectionName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") DataConnectionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/dataConnections/{dataConnectionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="dataConnectionName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

