/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.kusto.fluent.DatabaseOperationsClient;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInviteFollowerResultInner;
import com.azure.resourcemanager.kusto.implementation.KustoManagementClientImpl;
import com.azure.resourcemanager.kusto.models.DatabaseInviteFollowerRequest;
import reactor.core.publisher.Mono;

public final class DatabaseOperationsClientImpl
implements DatabaseOperationsClient {
    private final DatabaseOperationsService service;
    private final KustoManagementClientImpl client;

    DatabaseOperationsClientImpl(KustoManagementClientImpl client) {
        this.service = (DatabaseOperationsService)RestProxy.create(DatabaseOperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseInviteFollowerResultInner>> inviteFollowerWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.inviteFollower(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseInviteFollowerResultInner>> inviteFollowerWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.inviteFollower(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseInviteFollowerResultInner> inviteFollowerAsync(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters) {
        return this.inviteFollowerWithResponseAsync(resourceGroupName, clusterName, databaseName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((DatabaseInviteFollowerResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseInviteFollowerResultInner> inviteFollowerWithResponse(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters, Context context) {
        return (Response)this.inviteFollowerWithResponseAsync(resourceGroupName, clusterName, databaseName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseInviteFollowerResultInner inviteFollower(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters) {
        return (DatabaseInviteFollowerResultInner)this.inviteFollowerWithResponse(resourceGroupName, clusterName, databaseName, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KustoManagementClien")
    public static interface DatabaseOperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/inviteFollower")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseInviteFollowerResultInner>> inviteFollower(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseInviteFollowerRequest var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

