/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.DatabaseOperationsClient;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInviteFollowerResultInner;
import com.azure.resourcemanager.kusto.implementation.DatabaseInviteFollowerResultImpl;
import com.azure.resourcemanager.kusto.models.DatabaseInviteFollowerRequest;
import com.azure.resourcemanager.kusto.models.DatabaseInviteFollowerResult;
import com.azure.resourcemanager.kusto.models.DatabaseOperations;

public final class DatabaseOperationsImpl
implements DatabaseOperations {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseOperationsImpl.class);
    private final DatabaseOperationsClient innerClient;
    private final KustoManager serviceManager;

    public DatabaseOperationsImpl(DatabaseOperationsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseInviteFollowerResult> inviteFollowerWithResponse(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters, Context context) {
        Response<DatabaseInviteFollowerResultInner> inner = this.serviceClient().inviteFollowerWithResponse(resourceGroupName, clusterName, databaseName, parameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseInviteFollowerResultImpl((DatabaseInviteFollowerResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseInviteFollowerResult inviteFollower(String resourceGroupName, String clusterName, String databaseName, DatabaseInviteFollowerRequest parameters) {
        DatabaseInviteFollowerResultInner inner = this.serviceClient().inviteFollower(resourceGroupName, clusterName, databaseName, parameters);
        if (inner != null) {
            return new DatabaseInviteFollowerResultImpl(inner, this.manager());
        }
        return null;
    }

    private DatabaseOperationsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }
}

