/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.DatabasePrincipalAssignmentInner;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalAssignment;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalRole;
import com.azure.resourcemanager.kusto.models.PrincipalType;
import com.azure.resourcemanager.kusto.models.ProvisioningState;

public final class DatabasePrincipalAssignmentImpl
implements DatabasePrincipalAssignment,
DatabasePrincipalAssignment.Definition,
DatabasePrincipalAssignment.Update {
    private DatabasePrincipalAssignmentInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String databaseName;
    private String principalAssignmentName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String principalId() {
        return this.innerModel().principalId();
    }

    @Override
    public DatabasePrincipalRole role() {
        return this.innerModel().role();
    }

    @Override
    public String tenantId() {
        return this.innerModel().tenantId();
    }

    @Override
    public PrincipalType principalType() {
        return this.innerModel().principalType();
    }

    @Override
    public String tenantName() {
        return this.innerModel().tenantName();
    }

    @Override
    public String principalName() {
        return this.innerModel().principalName();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String aadObjectId() {
        return this.innerModel().aadObjectId();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DatabasePrincipalAssignmentInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabasePrincipalAssignmentImpl withExistingDatabase(String resourceGroupName, String clusterName, String databaseName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public DatabasePrincipalAssignment create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabasePrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabasePrincipalAssignment create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabasePrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, this.innerModel(), context);
        return this;
    }

    DatabasePrincipalAssignmentImpl(String name, KustoManager serviceManager) {
        this.innerObject = new DatabasePrincipalAssignmentInner();
        this.serviceManager = serviceManager;
        this.principalAssignmentName = name;
    }

    @Override
    public DatabasePrincipalAssignmentImpl update() {
        return this;
    }

    @Override
    public DatabasePrincipalAssignment apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabasePrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabasePrincipalAssignment apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabasePrincipalAssignments().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, this.innerModel(), context);
        return this;
    }

    DatabasePrincipalAssignmentImpl(DatabasePrincipalAssignmentInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
        this.databaseName = Utils.getValueFromIdByName(innerObject.id(), "databases");
        this.principalAssignmentName = Utils.getValueFromIdByName(innerObject.id(), "principalAssignments");
    }

    @Override
    public DatabasePrincipalAssignment refresh() {
        this.innerObject = (DatabasePrincipalAssignmentInner)((Object)this.serviceManager.serviceClient().getDatabasePrincipalAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatabasePrincipalAssignment refresh(Context context) {
        this.innerObject = (DatabasePrincipalAssignmentInner)((Object)this.serviceManager.serviceClient().getDatabasePrincipalAssignments().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.principalAssignmentName, context).getValue());
        return this;
    }

    @Override
    public DatabasePrincipalAssignmentImpl withPrincipalId(String principalId) {
        this.innerModel().withPrincipalId(principalId);
        return this;
    }

    @Override
    public DatabasePrincipalAssignmentImpl withRole(DatabasePrincipalRole role) {
        this.innerModel().withRole(role);
        return this;
    }

    @Override
    public DatabasePrincipalAssignmentImpl withTenantId(String tenantId) {
        this.innerModel().withTenantId(tenantId);
        return this;
    }

    @Override
    public DatabasePrincipalAssignmentImpl withPrincipalType(PrincipalType principalType) {
        this.innerModel().withPrincipalType(principalType);
        return this;
    }
}

