/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.DatabasePrincipalAssignmentsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.DatabasePrincipalAssignmentInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasePrincipalAssignmentImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalAssignment;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalAssignmentCheckNameRequest;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalAssignments;

public final class DatabasePrincipalAssignmentsImpl
implements DatabasePrincipalAssignments {
    private static final ClientLogger LOGGER = new ClientLogger(DatabasePrincipalAssignmentsImpl.class);
    private final DatabasePrincipalAssignmentsClient innerClient;
    private final KustoManager serviceManager;

    public DatabasePrincipalAssignmentsImpl(DatabasePrincipalAssignmentsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalAssignmentCheckNameRequest principalAssignmentName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, databaseName, principalAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalAssignmentCheckNameRequest principalAssignmentName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, databaseName, principalAssignmentName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DatabasePrincipalAssignment> getWithResponse(String resourceGroupName, String clusterName, String databaseName, String principalAssignmentName, Context context) {
        Response<DatabasePrincipalAssignmentInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, databaseName, principalAssignmentName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabasePrincipalAssignmentImpl((DatabasePrincipalAssignmentInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabasePrincipalAssignment get(String resourceGroupName, String clusterName, String databaseName, String principalAssignmentName) {
        DatabasePrincipalAssignmentInner inner = this.serviceClient().get(resourceGroupName, clusterName, databaseName, principalAssignmentName);
        if (inner != null) {
            return new DatabasePrincipalAssignmentImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String principalAssignmentName) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, principalAssignmentName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String principalAssignmentName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, principalAssignmentName, context);
    }

    @Override
    public PagedIterable<DatabasePrincipalAssignment> list(String resourceGroupName, String clusterName, String databaseName) {
        PagedIterable<DatabasePrincipalAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName, databaseName);
        return Utils.mapPage(inner, inner1 -> new DatabasePrincipalAssignmentImpl((DatabasePrincipalAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DatabasePrincipalAssignment> list(String resourceGroupName, String clusterName, String databaseName, Context context) {
        PagedIterable<DatabasePrincipalAssignmentInner> inner = this.serviceClient().list(resourceGroupName, clusterName, databaseName, context);
        return Utils.mapPage(inner, inner1 -> new DatabasePrincipalAssignmentImpl((DatabasePrincipalAssignmentInner)((Object)inner1), this.manager()));
    }

    @Override
    public DatabasePrincipalAssignment getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = Utils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String principalAssignmentName = Utils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        return (DatabasePrincipalAssignment)this.getWithResponse(resourceGroupName, clusterName, databaseName, principalAssignmentName, Context.NONE).getValue();
    }

    @Override
    public Response<DatabasePrincipalAssignment> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = Utils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String principalAssignmentName = Utils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, databaseName, principalAssignmentName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = Utils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String principalAssignmentName = Utils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, principalAssignmentName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = Utils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String principalAssignmentName = Utils.getValueFromIdByName(id, "principalAssignments");
        if (principalAssignmentName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'principalAssignments'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, principalAssignmentName, context);
    }

    private DatabasePrincipalAssignmentsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabasePrincipalAssignmentImpl define(String name) {
        return new DatabasePrincipalAssignmentImpl(name, this.manager());
    }
}

