/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.kusto.fluent.AttachedDatabaseConfigurationsClient;
import com.azure.resourcemanager.kusto.fluent.ClusterPrincipalAssignmentsClient;
import com.azure.resourcemanager.kusto.fluent.ClustersClient;
import com.azure.resourcemanager.kusto.fluent.DataConnectionsClient;
import com.azure.resourcemanager.kusto.fluent.DatabaseOperationsClient;
import com.azure.resourcemanager.kusto.fluent.DatabasePrincipalAssignmentsClient;
import com.azure.resourcemanager.kusto.fluent.DatabasesClient;
import com.azure.resourcemanager.kusto.fluent.KustoManagementClient;
import com.azure.resourcemanager.kusto.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.kusto.fluent.OperationsClient;
import com.azure.resourcemanager.kusto.fluent.OperationsResultsClient;
import com.azure.resourcemanager.kusto.fluent.OperationsResultsLocationsClient;
import com.azure.resourcemanager.kusto.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.kusto.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.kusto.fluent.SandboxCustomImagesClient;
import com.azure.resourcemanager.kusto.fluent.ScriptsClient;
import com.azure.resourcemanager.kusto.fluent.SkusClient;
import com.azure.resourcemanager.kusto.implementation.AttachedDatabaseConfigurationsClientImpl;
import com.azure.resourcemanager.kusto.implementation.ClusterPrincipalAssignmentsClientImpl;
import com.azure.resourcemanager.kusto.implementation.ClustersClientImpl;
import com.azure.resourcemanager.kusto.implementation.DataConnectionsClientImpl;
import com.azure.resourcemanager.kusto.implementation.DatabaseOperationsClientImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasePrincipalAssignmentsClientImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasesClientImpl;
import com.azure.resourcemanager.kusto.implementation.KustoManagementClientBuilder;
import com.azure.resourcemanager.kusto.implementation.ManagedPrivateEndpointsClientImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsClientImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsResultsClientImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsResultsLocationsClientImpl;
import com.azure.resourcemanager.kusto.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.kusto.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.kusto.implementation.SandboxCustomImagesClientImpl;
import com.azure.resourcemanager.kusto.implementation.ScriptsClientImpl;
import com.azure.resourcemanager.kusto.implementation.SkusClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=KustoManagementClientBuilder.class)
public final class KustoManagementClientImpl
implements KustoManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ClustersClient clusters;
    private final ClusterPrincipalAssignmentsClient clusterPrincipalAssignments;
    private final SkusClient skus;
    private final DatabasesClient databases;
    private final AttachedDatabaseConfigurationsClient attachedDatabaseConfigurations;
    private final ManagedPrivateEndpointsClient managedPrivateEndpoints;
    private final DatabaseOperationsClient databaseOperations;
    private final DatabasePrincipalAssignmentsClient databasePrincipalAssignments;
    private final ScriptsClient scripts;
    private final SandboxCustomImagesClient sandboxCustomImages;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final DataConnectionsClient dataConnections;
    private final OperationsClient operations;
    private final OperationsResultsClient operationsResults;
    private final OperationsResultsLocationsClient operationsResultsLocations;
    private static final ClientLogger LOGGER = new ClientLogger(KustoManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ClustersClient getClusters() {
        return this.clusters;
    }

    @Override
    public ClusterPrincipalAssignmentsClient getClusterPrincipalAssignments() {
        return this.clusterPrincipalAssignments;
    }

    @Override
    public SkusClient getSkus() {
        return this.skus;
    }

    @Override
    public DatabasesClient getDatabases() {
        return this.databases;
    }

    @Override
    public AttachedDatabaseConfigurationsClient getAttachedDatabaseConfigurations() {
        return this.attachedDatabaseConfigurations;
    }

    @Override
    public ManagedPrivateEndpointsClient getManagedPrivateEndpoints() {
        return this.managedPrivateEndpoints;
    }

    @Override
    public DatabaseOperationsClient getDatabaseOperations() {
        return this.databaseOperations;
    }

    @Override
    public DatabasePrincipalAssignmentsClient getDatabasePrincipalAssignments() {
        return this.databasePrincipalAssignments;
    }

    @Override
    public ScriptsClient getScripts() {
        return this.scripts;
    }

    @Override
    public SandboxCustomImagesClient getSandboxCustomImages() {
        return this.sandboxCustomImages;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public DataConnectionsClient getDataConnections() {
        return this.dataConnections;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public OperationsResultsClient getOperationsResults() {
        return this.operationsResults;
    }

    @Override
    public OperationsResultsLocationsClient getOperationsResultsLocations() {
        return this.operationsResultsLocations;
    }

    KustoManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-08-15";
        this.clusters = new ClustersClientImpl(this);
        this.clusterPrincipalAssignments = new ClusterPrincipalAssignmentsClientImpl(this);
        this.skus = new SkusClientImpl(this);
        this.databases = new DatabasesClientImpl(this);
        this.attachedDatabaseConfigurations = new AttachedDatabaseConfigurationsClientImpl(this);
        this.managedPrivateEndpoints = new ManagedPrivateEndpointsClientImpl(this);
        this.databaseOperations = new DatabaseOperationsClientImpl(this);
        this.databasePrincipalAssignments = new DatabasePrincipalAssignmentsClientImpl(this);
        this.scripts = new ScriptsClientImpl(this);
        this.sandboxCustomImages = new SandboxCustomImagesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.dataConnections = new DataConnectionsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.operationsResults = new OperationsResultsClientImpl(this);
        this.operationsResultsLocations = new OperationsResultsLocationsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

