/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.ManagedPrivateEndpointInner;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.ManagedPrivateEndpoint;
import com.azure.resourcemanager.kusto.models.ProvisioningState;

public final class ManagedPrivateEndpointImpl
implements ManagedPrivateEndpoint,
ManagedPrivateEndpoint.Definition,
ManagedPrivateEndpoint.Update {
    private ManagedPrivateEndpointInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String managedPrivateEndpointName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String privateLinkResourceId() {
        return this.innerModel().privateLinkResourceId();
    }

    @Override
    public String privateLinkResourceRegion() {
        return this.innerModel().privateLinkResourceRegion();
    }

    @Override
    public String groupId() {
        return this.innerModel().groupId();
    }

    @Override
    public String requestMessage() {
        return this.innerModel().requestMessage();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedPrivateEndpointInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public ManagedPrivateEndpoint create() {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdate(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedPrivateEndpoint create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().createOrUpdate(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, this.innerModel(), context);
        return this;
    }

    ManagedPrivateEndpointImpl(String name, KustoManager serviceManager) {
        this.innerObject = new ManagedPrivateEndpointInner();
        this.serviceManager = serviceManager;
        this.managedPrivateEndpointName = name;
    }

    @Override
    public ManagedPrivateEndpointImpl update() {
        return this;
    }

    @Override
    public ManagedPrivateEndpoint apply() {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().update(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedPrivateEndpoint apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getManagedPrivateEndpoints().update(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, this.innerModel(), context);
        return this;
    }

    ManagedPrivateEndpointImpl(ManagedPrivateEndpointInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
        this.managedPrivateEndpointName = Utils.getValueFromIdByName(innerObject.id(), "managedPrivateEndpoints");
    }

    @Override
    public ManagedPrivateEndpoint refresh() {
        this.innerObject = (ManagedPrivateEndpointInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpoint refresh(Context context) {
        this.innerObject = (ManagedPrivateEndpointInner)((Object)this.serviceManager.serviceClient().getManagedPrivateEndpoints().getWithResponse(this.resourceGroupName, this.clusterName, this.managedPrivateEndpointName, context).getValue());
        return this;
    }

    @Override
    public ManagedPrivateEndpointImpl withPrivateLinkResourceId(String privateLinkResourceId) {
        this.innerModel().withPrivateLinkResourceId(privateLinkResourceId);
        return this;
    }

    @Override
    public ManagedPrivateEndpointImpl withPrivateLinkResourceRegion(String privateLinkResourceRegion) {
        this.innerModel().withPrivateLinkResourceRegion(privateLinkResourceRegion);
        return this;
    }

    @Override
    public ManagedPrivateEndpointImpl withGroupId(String groupId) {
        this.innerModel().withGroupId(groupId);
        return this;
    }

    @Override
    public ManagedPrivateEndpointImpl withRequestMessage(String requestMessage) {
        this.innerModel().withRequestMessage(requestMessage);
        return this;
    }
}

