/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.ManagedPrivateEndpointInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.ManagedPrivateEndpointImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.ManagedPrivateEndpoint;
import com.azure.resourcemanager.kusto.models.ManagedPrivateEndpoints;
import com.azure.resourcemanager.kusto.models.ManagedPrivateEndpointsCheckNameRequest;

public final class ManagedPrivateEndpointsImpl
implements ManagedPrivateEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedPrivateEndpointsImpl.class);
    private final ManagedPrivateEndpointsClient innerClient;
    private final KustoManager serviceManager;

    public ManagedPrivateEndpointsImpl(ManagedPrivateEndpointsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, ManagedPrivateEndpointsCheckNameRequest resourceName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, ManagedPrivateEndpointsCheckNameRequest resourceName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, resourceName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ManagedPrivateEndpoint> list(String resourceGroupName, String clusterName) {
        PagedIterable<ManagedPrivateEndpointInner> inner = this.serviceClient().list(resourceGroupName, clusterName);
        return Utils.mapPage(inner, inner1 -> new ManagedPrivateEndpointImpl((ManagedPrivateEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedPrivateEndpoint> list(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<ManagedPrivateEndpointInner> inner = this.serviceClient().list(resourceGroupName, clusterName, context);
        return Utils.mapPage(inner, inner1 -> new ManagedPrivateEndpointImpl((ManagedPrivateEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ManagedPrivateEndpoint> getWithResponse(String resourceGroupName, String clusterName, String managedPrivateEndpointName, Context context) {
        Response<ManagedPrivateEndpointInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, managedPrivateEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedPrivateEndpointImpl((ManagedPrivateEndpointInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedPrivateEndpoint get(String resourceGroupName, String clusterName, String managedPrivateEndpointName) {
        ManagedPrivateEndpointInner inner = this.serviceClient().get(resourceGroupName, clusterName, managedPrivateEndpointName);
        if (inner != null) {
            return new ManagedPrivateEndpointImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String managedPrivateEndpointName) {
        this.serviceClient().delete(resourceGroupName, clusterName, managedPrivateEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String managedPrivateEndpointName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, managedPrivateEndpointName, context);
    }

    @Override
    public ManagedPrivateEndpoint getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String managedPrivateEndpointName = Utils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return (ManagedPrivateEndpoint)this.getWithResponse(resourceGroupName, clusterName, managedPrivateEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedPrivateEndpoint> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String managedPrivateEndpointName = Utils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, managedPrivateEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String managedPrivateEndpointName = Utils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        this.delete(resourceGroupName, clusterName, managedPrivateEndpointName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String managedPrivateEndpointName = Utils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        this.delete(resourceGroupName, clusterName, managedPrivateEndpointName, context);
    }

    private ManagedPrivateEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointImpl define(String name) {
        return new ManagedPrivateEndpointImpl(name, this.manager());
    }
}

