/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.OperationsResultsClient;
import com.azure.resourcemanager.kusto.fluent.models.OperationResultInner;
import com.azure.resourcemanager.kusto.implementation.OperationResultImpl;
import com.azure.resourcemanager.kusto.models.OperationResult;
import com.azure.resourcemanager.kusto.models.OperationsResults;

public final class OperationsResultsImpl
implements OperationsResults {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsResultsImpl.class);
    private final OperationsResultsClient innerClient;
    private final KustoManager serviceManager;

    public OperationsResultsImpl(OperationsResultsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<OperationResult> getWithResponse(String location, String operationId, Context context) {
        Response<OperationResultInner> inner = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationResultImpl((OperationResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OperationResult get(String location, String operationId) {
        OperationResultInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new OperationResultImpl(inner, this.manager());
        }
        return null;
    }

    private OperationsResultsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }
}

