/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.PrivateEndpointConnection;
import com.azure.resourcemanager.kusto.models.PrivateEndpointProperty;
import com.azure.resourcemanager.kusto.models.PrivateLinkServiceConnectionStateProperty;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition,
PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String privateEndpointConnectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public PrivateEndpointProperty privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    @Override
    public String groupId() {
        return this.innerModel().groupId();
    }

    @Override
    public String provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name, KustoManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
    }

    @Override
    public PrivateEndpointConnectionImpl update() {
        return this;
    }

    @Override
    public PrivateEndpointConnection apply() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = Utils.getValueFromIdByName(innerObject.id(), "clusters");
        this.privateEndpointConnectionName = Utils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.clusterName, this.privateEndpointConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        this.innerModel().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }
}

