/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.SandboxCustomImagesClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.SandboxCustomImageInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.SandboxCustomImageImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.SandboxCustomImage;
import com.azure.resourcemanager.kusto.models.SandboxCustomImages;
import com.azure.resourcemanager.kusto.models.SandboxCustomImagesCheckNameRequest;

public final class SandboxCustomImagesImpl
implements SandboxCustomImages {
    private static final ClientLogger LOGGER = new ClientLogger(SandboxCustomImagesImpl.class);
    private final SandboxCustomImagesClient innerClient;
    private final KustoManager serviceManager;

    public SandboxCustomImagesImpl(SandboxCustomImagesClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SandboxCustomImage> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<SandboxCustomImageInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return Utils.mapPage(inner, inner1 -> new SandboxCustomImageImpl((SandboxCustomImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SandboxCustomImage> listByCluster(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<SandboxCustomImageInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, context);
        return Utils.mapPage(inner, inner1 -> new SandboxCustomImageImpl((SandboxCustomImageInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<SandboxCustomImage> getWithResponse(String resourceGroupName, String clusterName, String sandboxCustomImageName, Context context) {
        Response<SandboxCustomImageInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, sandboxCustomImageName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SandboxCustomImageImpl((SandboxCustomImageInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public SandboxCustomImage get(String resourceGroupName, String clusterName, String sandboxCustomImageName) {
        SandboxCustomImageInner inner = this.serviceClient().get(resourceGroupName, clusterName, sandboxCustomImageName);
        if (inner != null) {
            return new SandboxCustomImageImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String sandboxCustomImageName) {
        this.serviceClient().delete(resourceGroupName, clusterName, sandboxCustomImageName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String sandboxCustomImageName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, sandboxCustomImageName, context);
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, SandboxCustomImagesCheckNameRequest resourceName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, SandboxCustomImagesCheckNameRequest resourceName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, resourceName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public SandboxCustomImage getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String sandboxCustomImageName = Utils.getValueFromIdByName(id, "sandboxCustomImages");
        if (sandboxCustomImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sandboxCustomImages'.", id)));
        }
        return (SandboxCustomImage)this.getWithResponse(resourceGroupName, clusterName, sandboxCustomImageName, Context.NONE).getValue();
    }

    @Override
    public Response<SandboxCustomImage> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String sandboxCustomImageName = Utils.getValueFromIdByName(id, "sandboxCustomImages");
        if (sandboxCustomImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sandboxCustomImages'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, sandboxCustomImageName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String sandboxCustomImageName = Utils.getValueFromIdByName(id, "sandboxCustomImages");
        if (sandboxCustomImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sandboxCustomImages'.", id)));
        }
        this.delete(resourceGroupName, clusterName, sandboxCustomImageName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = Utils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String sandboxCustomImageName = Utils.getValueFromIdByName(id, "sandboxCustomImages");
        if (sandboxCustomImageName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'sandboxCustomImages'.", id)));
        }
        this.delete(resourceGroupName, clusterName, sandboxCustomImageName, context);
    }

    private SandboxCustomImagesClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public SandboxCustomImageImpl define(String name) {
        return new SandboxCustomImageImpl(name, this.manager());
    }
}

