/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.SkusClient;
import com.azure.resourcemanager.kusto.fluent.models.SkuDescriptionInner;
import com.azure.resourcemanager.kusto.implementation.SkuDescriptionImpl;
import com.azure.resourcemanager.kusto.implementation.Utils;
import com.azure.resourcemanager.kusto.models.SkuDescription;
import com.azure.resourcemanager.kusto.models.Skus;

public final class SkusImpl
implements Skus {
    private static final ClientLogger LOGGER = new ClientLogger(SkusImpl.class);
    private final SkusClient innerClient;
    private final KustoManager serviceManager;

    public SkusImpl(SkusClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<SkuDescription> list(String location) {
        PagedIterable<SkuDescriptionInner> inner = this.serviceClient().list(location);
        return Utils.mapPage(inner, inner1 -> new SkuDescriptionImpl((SkuDescriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SkuDescription> list(String location, Context context) {
        PagedIterable<SkuDescriptionInner> inner = this.serviceClient().list(location, context);
        return Utils.mapPage(inner, inner1 -> new SkuDescriptionImpl((SkuDescriptionInner)inner1, this.manager()));
    }

    private SkusClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }
}

