/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.AzureScaleType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AzureCapacity {
    @JsonProperty(value="scaleType", required=true)
    private AzureScaleType scaleType;
    @JsonProperty(value="minimum", required=true)
    private int minimum;
    @JsonProperty(value="maximum", required=true)
    private int maximum;
    @JsonProperty(value="default", required=true)
    private int defaultProperty;
    private static final ClientLogger LOGGER = new ClientLogger(AzureCapacity.class);

    public AzureScaleType scaleType() {
        return this.scaleType;
    }

    public AzureCapacity withScaleType(AzureScaleType scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public int minimum() {
        return this.minimum;
    }

    public AzureCapacity withMinimum(int minimum) {
        this.minimum = minimum;
        return this;
    }

    public int maximum() {
        return this.maximum;
    }

    public AzureCapacity withMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    public int defaultProperty() {
        return this.defaultProperty;
    }

    public AzureCapacity withDefaultProperty(int defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public void validate() {
        if (this.scaleType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property scaleType in model AzureCapacity"));
        }
    }
}

