/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.CosmosDbDataConnectionProperties;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="CosmosDb")
public final class CosmosDbDataConnection
extends DataConnectionInner {
    @JsonProperty(value="properties")
    private CosmosDbDataConnectionProperties innerProperties;

    private CosmosDbDataConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public CosmosDbDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public CosmosDbDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public CosmosDbDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public String managedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityResourceId();
    }

    public CosmosDbDataConnection withManagedIdentityResourceId(String managedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withManagedIdentityResourceId(managedIdentityResourceId);
        return this;
    }

    public String managedIdentityObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityObjectId();
    }

    public String cosmosDbAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbAccountResourceId();
    }

    public CosmosDbDataConnection withCosmosDbAccountResourceId(String cosmosDbAccountResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbAccountResourceId(cosmosDbAccountResourceId);
        return this;
    }

    public String cosmosDbDatabase() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbDatabase();
    }

    public CosmosDbDataConnection withCosmosDbDatabase(String cosmosDbDatabase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbDatabase(cosmosDbDatabase);
        return this;
    }

    public String cosmosDbContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbContainer();
    }

    public CosmosDbDataConnection withCosmosDbContainer(String cosmosDbContainer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbContainer(cosmosDbContainer);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public CosmosDbDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

