/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.EventGridConnectionProperties;
import com.azure.resourcemanager.kusto.models.BlobStorageEventType;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventGridDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="EventGrid")
public final class EventGridDataConnection
extends DataConnectionInner {
    @JsonProperty(value="properties")
    private EventGridConnectionProperties innerProperties;

    private EventGridConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public EventGridDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String storageAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountResourceId();
    }

    public EventGridDataConnection withStorageAccountResourceId(String storageAccountResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withStorageAccountResourceId(storageAccountResourceId);
        return this;
    }

    public String eventGridResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().eventGridResourceId();
    }

    public EventGridDataConnection withEventGridResourceId(String eventGridResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withEventGridResourceId(eventGridResourceId);
        return this;
    }

    public String eventHubResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().eventHubResourceId();
    }

    public EventGridDataConnection withEventHubResourceId(String eventHubResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withEventHubResourceId(eventHubResourceId);
        return this;
    }

    public String consumerGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().consumerGroup();
    }

    public EventGridDataConnection withConsumerGroup(String consumerGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withConsumerGroup(consumerGroup);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public EventGridDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public EventGridDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public EventGridDataFormat dataFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFormat();
    }

    public EventGridDataConnection withDataFormat(EventGridDataFormat dataFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withDataFormat(dataFormat);
        return this;
    }

    public Boolean ignoreFirstRecord() {
        return this.innerProperties() == null ? null : this.innerProperties().ignoreFirstRecord();
    }

    public EventGridDataConnection withIgnoreFirstRecord(Boolean ignoreFirstRecord) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withIgnoreFirstRecord(ignoreFirstRecord);
        return this;
    }

    public BlobStorageEventType blobStorageEventType() {
        return this.innerProperties() == null ? null : this.innerProperties().blobStorageEventType();
    }

    public EventGridDataConnection withBlobStorageEventType(BlobStorageEventType blobStorageEventType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withBlobStorageEventType(blobStorageEventType);
        return this;
    }

    public String managedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityResourceId();
    }

    public EventGridDataConnection withManagedIdentityResourceId(String managedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withManagedIdentityResourceId(managedIdentityResourceId);
        return this;
    }

    public String managedIdentityObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityObjectId();
    }

    public DatabaseRouting databaseRouting() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseRouting();
    }

    public EventGridDataConnection withDatabaseRouting(DatabaseRouting databaseRouting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventGridConnectionProperties();
        }
        this.innerProperties().withDatabaseRouting(databaseRouting);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

