/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.EventHubConnectionProperties;
import com.azure.resourcemanager.kusto.models.Compression;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="EventHub")
public final class EventHubDataConnection
extends DataConnectionInner {
    @JsonProperty(value="properties")
    private EventHubConnectionProperties innerProperties;

    private EventHubConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public EventHubDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String eventHubResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().eventHubResourceId();
    }

    public EventHubDataConnection withEventHubResourceId(String eventHubResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withEventHubResourceId(eventHubResourceId);
        return this;
    }

    public String consumerGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().consumerGroup();
    }

    public EventHubDataConnection withConsumerGroup(String consumerGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withConsumerGroup(consumerGroup);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public EventHubDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public EventHubDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public EventHubDataFormat dataFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFormat();
    }

    public EventHubDataConnection withDataFormat(EventHubDataFormat dataFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withDataFormat(dataFormat);
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().eventSystemProperties();
    }

    public EventHubDataConnection withEventSystemProperties(List<String> eventSystemProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withEventSystemProperties(eventSystemProperties);
        return this;
    }

    public Compression compression() {
        return this.innerProperties() == null ? null : this.innerProperties().compression();
    }

    public EventHubDataConnection withCompression(Compression compression) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withCompression(compression);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String managedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityResourceId();
    }

    public EventHubDataConnection withManagedIdentityResourceId(String managedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withManagedIdentityResourceId(managedIdentityResourceId);
        return this;
    }

    public String managedIdentityObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityObjectId();
    }

    public DatabaseRouting databaseRouting() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseRouting();
    }

    public EventHubDataConnection withDatabaseRouting(DatabaseRouting databaseRouting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withDatabaseRouting(databaseRouting);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public EventHubDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EventHubConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

