/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.IotHubConnectionProperties;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.IotHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="IotHub")
public final class IotHubDataConnection
extends DataConnectionInner {
    @JsonProperty(value="properties")
    private IotHubConnectionProperties innerProperties;

    private IotHubConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public IotHubDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String iotHubResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().iotHubResourceId();
    }

    public IotHubDataConnection withIotHubResourceId(String iotHubResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withIotHubResourceId(iotHubResourceId);
        return this;
    }

    public String consumerGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().consumerGroup();
    }

    public IotHubDataConnection withConsumerGroup(String consumerGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withConsumerGroup(consumerGroup);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public IotHubDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public IotHubDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public IotHubDataFormat dataFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFormat();
    }

    public IotHubDataConnection withDataFormat(IotHubDataFormat dataFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withDataFormat(dataFormat);
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().eventSystemProperties();
    }

    public IotHubDataConnection withEventSystemProperties(List<String> eventSystemProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withEventSystemProperties(eventSystemProperties);
        return this;
    }

    public String sharedAccessPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedAccessPolicyName();
    }

    public IotHubDataConnection withSharedAccessPolicyName(String sharedAccessPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withSharedAccessPolicyName(sharedAccessPolicyName);
        return this;
    }

    public DatabaseRouting databaseRouting() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseRouting();
    }

    public IotHubDataConnection withDatabaseRouting(DatabaseRouting databaseRouting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withDatabaseRouting(databaseRouting);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public IotHubDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

