/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import com.azure.resourcemanager.kusto.fluent.models.ReadOnlyFollowingDatabaseProperties;
import com.azure.resourcemanager.kusto.models.DatabaseShareOrigin;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.PrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.Duration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="ReadOnlyFollowing")
public final class ReadOnlyFollowingDatabase
extends DatabaseInner {
    @JsonProperty(value="properties")
    private ReadOnlyFollowingDatabaseProperties innerProperties;

    private ReadOnlyFollowingDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ReadOnlyFollowingDatabase withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Duration softDeletePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletePeriod();
    }

    public Duration hotCachePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().hotCachePeriod();
    }

    public ReadOnlyFollowingDatabase withHotCachePeriod(Duration hotCachePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadOnlyFollowingDatabaseProperties();
        }
        this.innerProperties().withHotCachePeriod(hotCachePeriod);
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.innerProperties() == null ? null : this.innerProperties().statistics();
    }

    public String leaderClusterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().leaderClusterResourceId();
    }

    public String attachedDatabaseConfigurationName() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedDatabaseConfigurationName();
    }

    public PrincipalsModificationKind principalsModificationKind() {
        return this.innerProperties() == null ? null : this.innerProperties().principalsModificationKind();
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().tableLevelSharingProperties();
    }

    public String originalDatabaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().originalDatabaseName();
    }

    public DatabaseShareOrigin databaseShareOrigin() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseShareOrigin();
    }

    public SuspensionDetails suspensionDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().suspensionDetails();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

