/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import com.azure.resourcemanager.kusto.fluent.models.ReadWriteDatabaseProperties;
import com.azure.resourcemanager.kusto.models.DatabaseStatistics;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SuspensionDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.Duration;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonTypeName(value="ReadWrite")
public final class ReadWriteDatabase
extends DatabaseInner {
    @JsonProperty(value="properties")
    private ReadWriteDatabaseProperties innerProperties;

    private ReadWriteDatabaseProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ReadWriteDatabase withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Duration softDeletePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletePeriod();
    }

    public ReadWriteDatabase withSoftDeletePeriod(Duration softDeletePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withSoftDeletePeriod(softDeletePeriod);
        return this;
    }

    public Duration hotCachePeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().hotCachePeriod();
    }

    public ReadWriteDatabase withHotCachePeriod(Duration hotCachePeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withHotCachePeriod(hotCachePeriod);
        return this;
    }

    public DatabaseStatistics statistics() {
        return this.innerProperties() == null ? null : this.innerProperties().statistics();
    }

    public Boolean isFollowed() {
        return this.innerProperties() == null ? null : this.innerProperties().isFollowed();
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultProperties();
    }

    public ReadWriteDatabase withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReadWriteDatabaseProperties();
        }
        this.innerProperties().withKeyVaultProperties(keyVaultProperties);
        return this;
    }

    public SuspensionDetails suspensionDetails() {
        return this.innerProperties() == null ? null : this.innerProperties().suspensionDetails();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

