/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.AttachedDatabaseConfigurationProperties;
import com.azure.resourcemanager.kusto.models.DefaultPrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;
import java.util.List;

public final class AttachedDatabaseConfigurationInner
extends ProxyResource {
    private String location;
    private AttachedDatabaseConfigurationProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public AttachedDatabaseConfigurationInner withLocation(String location) {
        this.location = location;
        return this;
    }

    private AttachedDatabaseConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    public AttachedDatabaseConfigurationInner withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    public String clusterResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterResourceId();
    }

    public AttachedDatabaseConfigurationInner withClusterResourceId(String clusterResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withClusterResourceId(clusterResourceId);
        return this;
    }

    public List<String> attachedDatabaseNames() {
        return this.innerProperties() == null ? null : this.innerProperties().attachedDatabaseNames();
    }

    public DefaultPrincipalsModificationKind defaultPrincipalsModificationKind() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultPrincipalsModificationKind();
    }

    public AttachedDatabaseConfigurationInner withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind defaultPrincipalsModificationKind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withDefaultPrincipalsModificationKind(defaultPrincipalsModificationKind);
        return this;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().tableLevelSharingProperties();
    }

    public AttachedDatabaseConfigurationInner withTableLevelSharingProperties(TableLevelSharingProperties tableLevelSharingProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withTableLevelSharingProperties(tableLevelSharingProperties);
        return this;
    }

    public String databaseNameOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseNameOverride();
    }

    public AttachedDatabaseConfigurationInner withDatabaseNameOverride(String databaseNameOverride) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withDatabaseNameOverride(databaseNameOverride);
        return this;
    }

    public String databaseNamePrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseNamePrefix();
    }

    public AttachedDatabaseConfigurationInner withDatabaseNamePrefix(String databaseNamePrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AttachedDatabaseConfigurationProperties();
        }
        this.innerProperties().withDatabaseNamePrefix(databaseNamePrefix);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AttachedDatabaseConfigurationInner fromJson(JsonReader jsonReader) throws IOException {
        return (AttachedDatabaseConfigurationInner)((Object)jsonReader.readObject(reader -> {
            AttachedDatabaseConfigurationInner deserializedAttachedDatabaseConfigurationInner = new AttachedDatabaseConfigurationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationInner.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationInner.innerProperties = AttachedDatabaseConfigurationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttachedDatabaseConfigurationInner;
        }));
    }
}

