/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DefaultPrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import java.io.IOException;
import java.util.List;

public final class AttachedDatabaseConfigurationProperties
implements JsonSerializable<AttachedDatabaseConfigurationProperties> {
    private ProvisioningState provisioningState;
    private String databaseName;
    private String clusterResourceId;
    private List<String> attachedDatabaseNames;
    private DefaultPrincipalsModificationKind defaultPrincipalsModificationKind;
    private TableLevelSharingProperties tableLevelSharingProperties;
    private String databaseNameOverride;
    private String databaseNamePrefix;
    private static final ClientLogger LOGGER = new ClientLogger(AttachedDatabaseConfigurationProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String clusterResourceId() {
        return this.clusterResourceId;
    }

    public AttachedDatabaseConfigurationProperties withClusterResourceId(String clusterResourceId) {
        this.clusterResourceId = clusterResourceId;
        return this;
    }

    public List<String> attachedDatabaseNames() {
        return this.attachedDatabaseNames;
    }

    public DefaultPrincipalsModificationKind defaultPrincipalsModificationKind() {
        return this.defaultPrincipalsModificationKind;
    }

    public AttachedDatabaseConfigurationProperties withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind defaultPrincipalsModificationKind) {
        this.defaultPrincipalsModificationKind = defaultPrincipalsModificationKind;
        return this;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.tableLevelSharingProperties;
    }

    public AttachedDatabaseConfigurationProperties withTableLevelSharingProperties(TableLevelSharingProperties tableLevelSharingProperties) {
        this.tableLevelSharingProperties = tableLevelSharingProperties;
        return this;
    }

    public String databaseNameOverride() {
        return this.databaseNameOverride;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseNameOverride(String databaseNameOverride) {
        this.databaseNameOverride = databaseNameOverride;
        return this;
    }

    public String databaseNamePrefix() {
        return this.databaseNamePrefix;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseNamePrefix(String databaseNamePrefix) {
        this.databaseNamePrefix = databaseNamePrefix;
        return this;
    }

    public void validate() {
        if (this.databaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.clusterResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property clusterResourceId in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.defaultPrincipalsModificationKind() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property defaultPrincipalsModificationKind in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.tableLevelSharingProperties() != null) {
            this.tableLevelSharingProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("clusterResourceId", this.clusterResourceId);
        jsonWriter.writeStringField("defaultPrincipalsModificationKind", this.defaultPrincipalsModificationKind == null ? null : this.defaultPrincipalsModificationKind.toString());
        jsonWriter.writeJsonField("tableLevelSharingProperties", (JsonSerializable)this.tableLevelSharingProperties);
        jsonWriter.writeStringField("databaseNameOverride", this.databaseNameOverride);
        jsonWriter.writeStringField("databaseNamePrefix", this.databaseNamePrefix);
        return jsonWriter.writeEndObject();
    }

    public static AttachedDatabaseConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AttachedDatabaseConfigurationProperties)jsonReader.readObject(reader -> {
            AttachedDatabaseConfigurationProperties deserializedAttachedDatabaseConfigurationProperties = new AttachedDatabaseConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("databaseName".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.databaseName = reader.getString();
                    continue;
                }
                if ("clusterResourceId".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.clusterResourceId = reader.getString();
                    continue;
                }
                if ("defaultPrincipalsModificationKind".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.defaultPrincipalsModificationKind = DefaultPrincipalsModificationKind.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("attachedDatabaseNames".equals(fieldName)) {
                    List attachedDatabaseNames;
                    deserializedAttachedDatabaseConfigurationProperties.attachedDatabaseNames = attachedDatabaseNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tableLevelSharingProperties".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.tableLevelSharingProperties = TableLevelSharingProperties.fromJson(reader);
                    continue;
                }
                if ("databaseNameOverride".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.databaseNameOverride = reader.getString();
                    continue;
                }
                if ("databaseNamePrefix".equals(fieldName)) {
                    deserializedAttachedDatabaseConfigurationProperties.databaseNamePrefix = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAttachedDatabaseConfigurationProperties;
        });
    }
}

