/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.kusto.models.AcceptedAudiences;
import com.azure.resourcemanager.kusto.models.ClusterNetworkAccessFlag;
import com.azure.resourcemanager.kusto.models.EngineType;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.MigrationClusterProperties;
import com.azure.resourcemanager.kusto.models.OptimizedAutoscale;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.PublicIpType;
import com.azure.resourcemanager.kusto.models.PublicNetworkAccess;
import com.azure.resourcemanager.kusto.models.State;
import com.azure.resourcemanager.kusto.models.TrustedExternalTenant;
import com.azure.resourcemanager.kusto.models.VirtualNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class ClusterProperties
implements JsonSerializable<ClusterProperties> {
    private State state;
    private ProvisioningState provisioningState;
    private String uri;
    private String dataIngestionUri;
    private String stateReason;
    private List<TrustedExternalTenant> trustedExternalTenants;
    private OptimizedAutoscale optimizedAutoscale;
    private Boolean enableDiskEncryption;
    private Boolean enableStreamingIngest;
    private VirtualNetworkConfiguration virtualNetworkConfiguration;
    private KeyVaultProperties keyVaultProperties;
    private Boolean enablePurge;
    private LanguageExtensionsList languageExtensions;
    private Boolean enableDoubleEncryption;
    private PublicNetworkAccess publicNetworkAccess;
    private List<String> allowedIpRangeList;
    private EngineType engineType;
    private List<AcceptedAudiences> acceptedAudiences;
    private Boolean enableAutoStop;
    private ClusterNetworkAccessFlag restrictOutboundNetworkAccess;
    private List<String> allowedFqdnList;
    private PublicIpType publicIpType;
    private String virtualClusterGraduationProperties;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private MigrationClusterProperties migrationCluster;

    public State state() {
        return this.state;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String uri() {
        return this.uri;
    }

    public String dataIngestionUri() {
        return this.dataIngestionUri;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public List<TrustedExternalTenant> trustedExternalTenants() {
        return this.trustedExternalTenants;
    }

    public ClusterProperties withTrustedExternalTenants(List<TrustedExternalTenant> trustedExternalTenants) {
        this.trustedExternalTenants = trustedExternalTenants;
        return this;
    }

    public OptimizedAutoscale optimizedAutoscale() {
        return this.optimizedAutoscale;
    }

    public ClusterProperties withOptimizedAutoscale(OptimizedAutoscale optimizedAutoscale) {
        this.optimizedAutoscale = optimizedAutoscale;
        return this;
    }

    public Boolean enableDiskEncryption() {
        return this.enableDiskEncryption;
    }

    public ClusterProperties withEnableDiskEncryption(Boolean enableDiskEncryption) {
        this.enableDiskEncryption = enableDiskEncryption;
        return this;
    }

    public Boolean enableStreamingIngest() {
        return this.enableStreamingIngest;
    }

    public ClusterProperties withEnableStreamingIngest(Boolean enableStreamingIngest) {
        this.enableStreamingIngest = enableStreamingIngest;
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.virtualNetworkConfiguration;
    }

    public ClusterProperties withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        this.virtualNetworkConfiguration = virtualNetworkConfiguration;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ClusterProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public Boolean enablePurge() {
        return this.enablePurge;
    }

    public ClusterProperties withEnablePurge(Boolean enablePurge) {
        this.enablePurge = enablePurge;
        return this;
    }

    public LanguageExtensionsList languageExtensions() {
        return this.languageExtensions;
    }

    public ClusterProperties withLanguageExtensions(LanguageExtensionsList languageExtensions) {
        this.languageExtensions = languageExtensions;
        return this;
    }

    public Boolean enableDoubleEncryption() {
        return this.enableDoubleEncryption;
    }

    public ClusterProperties withEnableDoubleEncryption(Boolean enableDoubleEncryption) {
        this.enableDoubleEncryption = enableDoubleEncryption;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<String> allowedIpRangeList() {
        return this.allowedIpRangeList;
    }

    public ClusterProperties withAllowedIpRangeList(List<String> allowedIpRangeList) {
        this.allowedIpRangeList = allowedIpRangeList;
        return this;
    }

    public EngineType engineType() {
        return this.engineType;
    }

    public ClusterProperties withEngineType(EngineType engineType) {
        this.engineType = engineType;
        return this;
    }

    public List<AcceptedAudiences> acceptedAudiences() {
        return this.acceptedAudiences;
    }

    public ClusterProperties withAcceptedAudiences(List<AcceptedAudiences> acceptedAudiences) {
        this.acceptedAudiences = acceptedAudiences;
        return this;
    }

    public Boolean enableAutoStop() {
        return this.enableAutoStop;
    }

    public ClusterProperties withEnableAutoStop(Boolean enableAutoStop) {
        this.enableAutoStop = enableAutoStop;
        return this;
    }

    public ClusterNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public ClusterProperties withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public List<String> allowedFqdnList() {
        return this.allowedFqdnList;
    }

    public ClusterProperties withAllowedFqdnList(List<String> allowedFqdnList) {
        this.allowedFqdnList = allowedFqdnList;
        return this;
    }

    public PublicIpType publicIpType() {
        return this.publicIpType;
    }

    public ClusterProperties withPublicIpType(PublicIpType publicIpType) {
        this.publicIpType = publicIpType;
        return this;
    }

    public String virtualClusterGraduationProperties() {
        return this.virtualClusterGraduationProperties;
    }

    public ClusterProperties withVirtualClusterGraduationProperties(String virtualClusterGraduationProperties) {
        this.virtualClusterGraduationProperties = virtualClusterGraduationProperties;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public MigrationClusterProperties migrationCluster() {
        return this.migrationCluster;
    }

    public void validate() {
        if (this.trustedExternalTenants() != null) {
            this.trustedExternalTenants().forEach(e -> e.validate());
        }
        if (this.optimizedAutoscale() != null) {
            this.optimizedAutoscale().validate();
        }
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.languageExtensions() != null) {
            this.languageExtensions().validate();
        }
        if (this.acceptedAudiences() != null) {
            this.acceptedAudiences().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.migrationCluster() != null) {
            this.migrationCluster().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("trustedExternalTenants", this.trustedExternalTenants, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("optimizedAutoscale", (JsonSerializable)this.optimizedAutoscale);
        jsonWriter.writeBooleanField("enableDiskEncryption", this.enableDiskEncryption);
        jsonWriter.writeBooleanField("enableStreamingIngest", this.enableStreamingIngest);
        jsonWriter.writeJsonField("virtualNetworkConfiguration", (JsonSerializable)this.virtualNetworkConfiguration);
        jsonWriter.writeJsonField("keyVaultProperties", (JsonSerializable)this.keyVaultProperties);
        jsonWriter.writeBooleanField("enablePurge", this.enablePurge);
        jsonWriter.writeJsonField("languageExtensions", (JsonSerializable)this.languageExtensions);
        jsonWriter.writeBooleanField("enableDoubleEncryption", this.enableDoubleEncryption);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeArrayField("allowedIpRangeList", this.allowedIpRangeList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("engineType", this.engineType == null ? null : this.engineType.toString());
        jsonWriter.writeArrayField("acceptedAudiences", this.acceptedAudiences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableAutoStop", this.enableAutoStop);
        jsonWriter.writeStringField("restrictOutboundNetworkAccess", this.restrictOutboundNetworkAccess == null ? null : this.restrictOutboundNetworkAccess.toString());
        jsonWriter.writeArrayField("allowedFqdnList", this.allowedFqdnList, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("publicIPType", this.publicIpType == null ? null : this.publicIpType.toString());
        jsonWriter.writeStringField("virtualClusterGraduationProperties", this.virtualClusterGraduationProperties);
        return jsonWriter.writeEndObject();
    }

    public static ClusterProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ClusterProperties)jsonReader.readObject(reader -> {
            ClusterProperties deserializedClusterProperties = new ClusterProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedClusterProperties.state = State.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedClusterProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedClusterProperties.uri = reader.getString();
                    continue;
                }
                if ("dataIngestionUri".equals(fieldName)) {
                    deserializedClusterProperties.dataIngestionUri = reader.getString();
                    continue;
                }
                if ("stateReason".equals(fieldName)) {
                    deserializedClusterProperties.stateReason = reader.getString();
                    continue;
                }
                if ("trustedExternalTenants".equals(fieldName)) {
                    List trustedExternalTenants;
                    deserializedClusterProperties.trustedExternalTenants = trustedExternalTenants = reader.readArray(reader1 -> TrustedExternalTenant.fromJson(reader1));
                    continue;
                }
                if ("optimizedAutoscale".equals(fieldName)) {
                    deserializedClusterProperties.optimizedAutoscale = OptimizedAutoscale.fromJson(reader);
                    continue;
                }
                if ("enableDiskEncryption".equals(fieldName)) {
                    deserializedClusterProperties.enableDiskEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableStreamingIngest".equals(fieldName)) {
                    deserializedClusterProperties.enableStreamingIngest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedClusterProperties.virtualNetworkConfiguration = VirtualNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedClusterProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("enablePurge".equals(fieldName)) {
                    deserializedClusterProperties.enablePurge = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("languageExtensions".equals(fieldName)) {
                    deserializedClusterProperties.languageExtensions = LanguageExtensionsList.fromJson(reader);
                    continue;
                }
                if ("enableDoubleEncryption".equals(fieldName)) {
                    deserializedClusterProperties.enableDoubleEncryption = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedClusterProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("allowedIpRangeList".equals(fieldName)) {
                    List allowedIpRangeList;
                    deserializedClusterProperties.allowedIpRangeList = allowedIpRangeList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("engineType".equals(fieldName)) {
                    deserializedClusterProperties.engineType = EngineType.fromString(reader.getString());
                    continue;
                }
                if ("acceptedAudiences".equals(fieldName)) {
                    List acceptedAudiences;
                    deserializedClusterProperties.acceptedAudiences = acceptedAudiences = reader.readArray(reader1 -> AcceptedAudiences.fromJson(reader1));
                    continue;
                }
                if ("enableAutoStop".equals(fieldName)) {
                    deserializedClusterProperties.enableAutoStop = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("restrictOutboundNetworkAccess".equals(fieldName)) {
                    deserializedClusterProperties.restrictOutboundNetworkAccess = ClusterNetworkAccessFlag.fromString(reader.getString());
                    continue;
                }
                if ("allowedFqdnList".equals(fieldName)) {
                    List allowedFqdnList;
                    deserializedClusterProperties.allowedFqdnList = allowedFqdnList = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("publicIPType".equals(fieldName)) {
                    deserializedClusterProperties.publicIpType = PublicIpType.fromString(reader.getString());
                    continue;
                }
                if ("virtualClusterGraduationProperties".equals(fieldName)) {
                    deserializedClusterProperties.virtualClusterGraduationProperties = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedClusterProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("migrationCluster".equals(fieldName)) {
                    deserializedClusterProperties.migrationCluster = MigrationClusterProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClusterProperties;
        });
    }
}

