/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.CosmosDbDataConnection;
import com.azure.resourcemanager.kusto.models.DataConnectionKind;
import com.azure.resourcemanager.kusto.models.EventGridDataConnection;
import com.azure.resourcemanager.kusto.models.EventHubDataConnection;
import com.azure.resourcemanager.kusto.models.IotHubDataConnection;
import java.io.IOException;

public class DataConnectionInner
extends ProxyResource {
    private DataConnectionKind kind = DataConnectionKind.fromString("DataConnection");
    private String location;
    private String type;
    private String name;
    private String id;

    public DataConnectionKind kind() {
        return this.kind;
    }

    public String location() {
        return this.location;
    }

    public DataConnectionInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static DataConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (DataConnectionInner)((Object)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DataConnectionInner dataConnectionInner;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("EventHub".equals(discriminatorValue)) {
                    dataConnectionInner = EventHubDataConnection.fromJson(readerToUse.reset());
                    return dataConnectionInner;
                }
                if ("IotHub".equals(discriminatorValue)) {
                    dataConnectionInner = IotHubDataConnection.fromJson(readerToUse.reset());
                    return dataConnectionInner;
                }
                if ("EventGrid".equals(discriminatorValue)) {
                    dataConnectionInner = EventGridDataConnection.fromJson(readerToUse.reset());
                    return dataConnectionInner;
                }
                if ("CosmosDb".equals(discriminatorValue)) {
                    dataConnectionInner = CosmosDbDataConnection.fromJson(readerToUse.reset());
                    return dataConnectionInner;
                }
                dataConnectionInner = DataConnectionInner.fromJsonKnownDiscriminator(readerToUse.reset());
                return dataConnectionInner;
            }
        }));
    }

    static DataConnectionInner fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DataConnectionInner)((Object)jsonReader.readObject(reader -> {
            DataConnectionInner deserializedDataConnectionInner = new DataConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDataConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDataConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataConnectionInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedDataConnectionInner.kind = DataConnectionKind.fromString(reader.getString());
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDataConnectionInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataConnectionInner;
        }));
    }
}

