/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalRole;
import com.azure.resourcemanager.kusto.models.PrincipalType;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class DatabasePrincipalProperties
implements JsonSerializable<DatabasePrincipalProperties> {
    private String principalId;
    private DatabasePrincipalRole role;
    private String tenantId;
    private PrincipalType principalType;
    private String tenantName;
    private String principalName;
    private ProvisioningState provisioningState;
    private String aadObjectId;
    private static final ClientLogger LOGGER = new ClientLogger(DatabasePrincipalProperties.class);

    public String principalId() {
        return this.principalId;
    }

    public DatabasePrincipalProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public DatabasePrincipalRole role() {
        return this.role;
    }

    public DatabasePrincipalProperties withRole(DatabasePrincipalRole role) {
        this.role = role;
        return this;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public DatabasePrincipalProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public DatabasePrincipalProperties withPrincipalType(PrincipalType principalType) {
        this.principalType = principalType;
        return this;
    }

    public String tenantName() {
        return this.tenantName;
    }

    public String principalName() {
        return this.principalName;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String aadObjectId() {
        return this.aadObjectId;
    }

    public void validate() {
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model DatabasePrincipalProperties"));
        }
        if (this.role() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property role in model DatabasePrincipalProperties"));
        }
        if (this.principalType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalType in model DatabasePrincipalProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("principalType", this.principalType == null ? null : this.principalType.toString());
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    public static DatabasePrincipalProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabasePrincipalProperties)jsonReader.readObject(reader -> {
            DatabasePrincipalProperties deserializedDatabasePrincipalProperties = new DatabasePrincipalProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.principalId = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.role = DatabasePrincipalRole.fromString(reader.getString());
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.tenantId = reader.getString();
                    continue;
                }
                if ("tenantName".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.tenantName = reader.getString();
                    continue;
                }
                if ("principalName".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.principalName = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("aadObjectId".equals(fieldName)) {
                    deserializedDatabasePrincipalProperties.aadObjectId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabasePrincipalProperties;
        });
    }
}

