/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.BlobStorageEventType;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.EventGridDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class EventGridConnectionProperties
implements JsonSerializable<EventGridConnectionProperties> {
    private String storageAccountResourceId;
    private String eventGridResourceId;
    private String eventHubResourceId;
    private String consumerGroup;
    private String tableName;
    private String mappingRuleName;
    private EventGridDataFormat dataFormat;
    private Boolean ignoreFirstRecord;
    private BlobStorageEventType blobStorageEventType;
    private String managedIdentityResourceId;
    private String managedIdentityObjectId;
    private DatabaseRouting databaseRouting;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(EventGridConnectionProperties.class);

    public String storageAccountResourceId() {
        return this.storageAccountResourceId;
    }

    public EventGridConnectionProperties withStorageAccountResourceId(String storageAccountResourceId) {
        this.storageAccountResourceId = storageAccountResourceId;
        return this;
    }

    public String eventGridResourceId() {
        return this.eventGridResourceId;
    }

    public EventGridConnectionProperties withEventGridResourceId(String eventGridResourceId) {
        this.eventGridResourceId = eventGridResourceId;
        return this;
    }

    public String eventHubResourceId() {
        return this.eventHubResourceId;
    }

    public EventGridConnectionProperties withEventHubResourceId(String eventHubResourceId) {
        this.eventHubResourceId = eventHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public EventGridConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public EventGridConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public EventGridConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public EventGridDataFormat dataFormat() {
        return this.dataFormat;
    }

    public EventGridConnectionProperties withDataFormat(EventGridDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public Boolean ignoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public EventGridConnectionProperties withIgnoreFirstRecord(Boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
        return this;
    }

    public BlobStorageEventType blobStorageEventType() {
        return this.blobStorageEventType;
    }

    public EventGridConnectionProperties withBlobStorageEventType(BlobStorageEventType blobStorageEventType) {
        this.blobStorageEventType = blobStorageEventType;
        return this;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public EventGridConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public EventGridConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.storageAccountResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property storageAccountResourceId in model EventGridConnectionProperties"));
        }
        if (this.eventHubResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property eventHubResourceId in model EventGridConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model EventGridConnectionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountResourceId", this.storageAccountResourceId);
        jsonWriter.writeStringField("eventHubResourceId", this.eventHubResourceId);
        jsonWriter.writeStringField("consumerGroup", this.consumerGroup);
        jsonWriter.writeStringField("eventGridResourceId", this.eventGridResourceId);
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("mappingRuleName", this.mappingRuleName);
        jsonWriter.writeStringField("dataFormat", this.dataFormat == null ? null : this.dataFormat.toString());
        jsonWriter.writeBooleanField("ignoreFirstRecord", this.ignoreFirstRecord);
        jsonWriter.writeStringField("blobStorageEventType", this.blobStorageEventType == null ? null : this.blobStorageEventType.toString());
        jsonWriter.writeStringField("managedIdentityResourceId", this.managedIdentityResourceId);
        jsonWriter.writeStringField("databaseRouting", this.databaseRouting == null ? null : this.databaseRouting.toString());
        return jsonWriter.writeEndObject();
    }

    public static EventGridConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventGridConnectionProperties)jsonReader.readObject(reader -> {
            EventGridConnectionProperties deserializedEventGridConnectionProperties = new EventGridConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageAccountResourceId".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.storageAccountResourceId = reader.getString();
                    continue;
                }
                if ("eventHubResourceId".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.eventHubResourceId = reader.getString();
                    continue;
                }
                if ("consumerGroup".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.consumerGroup = reader.getString();
                    continue;
                }
                if ("eventGridResourceId".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.eventGridResourceId = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.tableName = reader.getString();
                    continue;
                }
                if ("mappingRuleName".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.mappingRuleName = reader.getString();
                    continue;
                }
                if ("dataFormat".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.dataFormat = EventGridDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("ignoreFirstRecord".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.ignoreFirstRecord = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("blobStorageEventType".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.blobStorageEventType = BlobStorageEventType.fromString(reader.getString());
                    continue;
                }
                if ("managedIdentityResourceId".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.managedIdentityResourceId = reader.getString();
                    continue;
                }
                if ("managedIdentityObjectId".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.managedIdentityObjectId = reader.getString();
                    continue;
                }
                if ("databaseRouting".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.databaseRouting = DatabaseRouting.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedEventGridConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventGridConnectionProperties;
        });
    }
}

