/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.IotHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class IotHubConnectionProperties
implements JsonSerializable<IotHubConnectionProperties> {
    private String iotHubResourceId;
    private String consumerGroup;
    private String tableName;
    private String mappingRuleName;
    private IotHubDataFormat dataFormat;
    private List<String> eventSystemProperties;
    private String sharedAccessPolicyName;
    private DatabaseRouting databaseRouting;
    private OffsetDateTime retrievalStartDate;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(IotHubConnectionProperties.class);

    public String iotHubResourceId() {
        return this.iotHubResourceId;
    }

    public IotHubConnectionProperties withIotHubResourceId(String iotHubResourceId) {
        this.iotHubResourceId = iotHubResourceId;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public IotHubConnectionProperties withConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String tableName() {
        return this.tableName;
    }

    public IotHubConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public IotHubConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public IotHubDataFormat dataFormat() {
        return this.dataFormat;
    }

    public IotHubConnectionProperties withDataFormat(IotHubDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.eventSystemProperties;
    }

    public IotHubConnectionProperties withEventSystemProperties(List<String> eventSystemProperties) {
        this.eventSystemProperties = eventSystemProperties;
        return this;
    }

    public String sharedAccessPolicyName() {
        return this.sharedAccessPolicyName;
    }

    public IotHubConnectionProperties withSharedAccessPolicyName(String sharedAccessPolicyName) {
        this.sharedAccessPolicyName = sharedAccessPolicyName;
        return this;
    }

    public DatabaseRouting databaseRouting() {
        return this.databaseRouting;
    }

    public IotHubConnectionProperties withDatabaseRouting(DatabaseRouting databaseRouting) {
        this.databaseRouting = databaseRouting;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public IotHubConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.iotHubResourceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property iotHubResourceId in model IotHubConnectionProperties"));
        }
        if (this.consumerGroup() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property consumerGroup in model IotHubConnectionProperties"));
        }
        if (this.sharedAccessPolicyName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sharedAccessPolicyName in model IotHubConnectionProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("iotHubResourceId", this.iotHubResourceId);
        jsonWriter.writeStringField("consumerGroup", this.consumerGroup);
        jsonWriter.writeStringField("sharedAccessPolicyName", this.sharedAccessPolicyName);
        jsonWriter.writeStringField("tableName", this.tableName);
        jsonWriter.writeStringField("mappingRuleName", this.mappingRuleName);
        jsonWriter.writeStringField("dataFormat", this.dataFormat == null ? null : this.dataFormat.toString());
        jsonWriter.writeArrayField("eventSystemProperties", this.eventSystemProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("databaseRouting", this.databaseRouting == null ? null : this.databaseRouting.toString());
        jsonWriter.writeStringField("retrievalStartDate", this.retrievalStartDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.retrievalStartDate));
        return jsonWriter.writeEndObject();
    }

    public static IotHubConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubConnectionProperties)jsonReader.readObject(reader -> {
            IotHubConnectionProperties deserializedIotHubConnectionProperties = new IotHubConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("iotHubResourceId".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.iotHubResourceId = reader.getString();
                    continue;
                }
                if ("consumerGroup".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.consumerGroup = reader.getString();
                    continue;
                }
                if ("sharedAccessPolicyName".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.sharedAccessPolicyName = reader.getString();
                    continue;
                }
                if ("tableName".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.tableName = reader.getString();
                    continue;
                }
                if ("mappingRuleName".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.mappingRuleName = reader.getString();
                    continue;
                }
                if ("dataFormat".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.dataFormat = IotHubDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("eventSystemProperties".equals(fieldName)) {
                    List eventSystemProperties;
                    deserializedIotHubConnectionProperties.eventSystemProperties = eventSystemProperties = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("databaseRouting".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.databaseRouting = DatabaseRouting.fromString(reader.getString());
                    continue;
                }
                if ("retrievalStartDate".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.retrievalStartDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedIotHubConnectionProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubConnectionProperties;
        });
    }
}

