/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.Language;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class SandboxCustomImageProperties
implements JsonSerializable<SandboxCustomImageProperties> {
    private Language language;
    private String languageVersion;
    private String requirementsFileContent;
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(SandboxCustomImageProperties.class);

    public Language language() {
        return this.language;
    }

    public SandboxCustomImageProperties withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public String languageVersion() {
        return this.languageVersion;
    }

    public SandboxCustomImageProperties withLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
        return this;
    }

    public String requirementsFileContent() {
        return this.requirementsFileContent;
    }

    public SandboxCustomImageProperties withRequirementsFileContent(String requirementsFileContent) {
        this.requirementsFileContent = requirementsFileContent;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.language() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property language in model SandboxCustomImageProperties"));
        }
        if (this.languageVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property languageVersion in model SandboxCustomImageProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("language", this.language == null ? null : this.language.toString());
        jsonWriter.writeStringField("languageVersion", this.languageVersion);
        jsonWriter.writeStringField("requirementsFileContent", this.requirementsFileContent);
        return jsonWriter.writeEndObject();
    }

    public static SandboxCustomImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SandboxCustomImageProperties)jsonReader.readObject(reader -> {
            SandboxCustomImageProperties deserializedSandboxCustomImageProperties = new SandboxCustomImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("language".equals(fieldName)) {
                    deserializedSandboxCustomImageProperties.language = Language.fromString(reader.getString());
                    continue;
                }
                if ("languageVersion".equals(fieldName)) {
                    deserializedSandboxCustomImageProperties.languageVersion = reader.getString();
                    continue;
                }
                if ("requirementsFileContent".equals(fieldName)) {
                    deserializedSandboxCustomImageProperties.requirementsFileContent = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSandboxCustomImageProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSandboxCustomImageProperties;
        });
    }
}

