/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.ScriptProperties;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;

public final class ScriptInner
extends ProxyResource {
    private ScriptProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ScriptProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String scriptUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptUrl();
    }

    public ScriptInner withScriptUrl(String scriptUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScriptProperties();
        }
        this.innerProperties().withScriptUrl(scriptUrl);
        return this;
    }

    public String scriptUrlSasToken() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptUrlSasToken();
    }

    public ScriptInner withScriptUrlSasToken(String scriptUrlSasToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScriptProperties();
        }
        this.innerProperties().withScriptUrlSasToken(scriptUrlSasToken);
        return this;
    }

    public String scriptContent() {
        return this.innerProperties() == null ? null : this.innerProperties().scriptContent();
    }

    public ScriptInner withScriptContent(String scriptContent) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScriptProperties();
        }
        this.innerProperties().withScriptContent(scriptContent);
        return this;
    }

    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    public ScriptInner withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScriptProperties();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    public Boolean continueOnErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().continueOnErrors();
    }

    public ScriptInner withContinueOnErrors(Boolean continueOnErrors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScriptProperties();
        }
        this.innerProperties().withContinueOnErrors(continueOnErrors);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScriptInner fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptInner)((Object)jsonReader.readObject(reader -> {
            ScriptInner deserializedScriptInner = new ScriptInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedScriptInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedScriptInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScriptInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScriptInner.innerProperties = ScriptProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedScriptInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScriptInner;
        }));
    }
}

