/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.ClustersClient;
import com.azure.resourcemanager.kusto.fluent.models.AzureResourceSkuInner;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.ClusterInner;
import com.azure.resourcemanager.kusto.fluent.models.DiagnoseVirtualNetworkResultInner;
import com.azure.resourcemanager.kusto.fluent.models.FollowerDatabaseDefinitionInner;
import com.azure.resourcemanager.kusto.fluent.models.LanguageExtensionInner;
import com.azure.resourcemanager.kusto.fluent.models.OutboundNetworkDependenciesEndpointInner;
import com.azure.resourcemanager.kusto.fluent.models.SkuDescriptionInner;
import com.azure.resourcemanager.kusto.implementation.AzureResourceSkuImpl;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.ClusterImpl;
import com.azure.resourcemanager.kusto.implementation.DiagnoseVirtualNetworkResultImpl;
import com.azure.resourcemanager.kusto.implementation.FollowerDatabaseDefinitionImpl;
import com.azure.resourcemanager.kusto.implementation.LanguageExtensionImpl;
import com.azure.resourcemanager.kusto.implementation.OutboundNetworkDependenciesEndpointImpl;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.implementation.SkuDescriptionImpl;
import com.azure.resourcemanager.kusto.models.AzureResourceSku;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.Cluster;
import com.azure.resourcemanager.kusto.models.ClusterCheckNameRequest;
import com.azure.resourcemanager.kusto.models.ClusterMigrateRequest;
import com.azure.resourcemanager.kusto.models.Clusters;
import com.azure.resourcemanager.kusto.models.DiagnoseVirtualNetworkResult;
import com.azure.resourcemanager.kusto.models.FollowerDatabaseDefinition;
import com.azure.resourcemanager.kusto.models.LanguageExtension;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.OutboundNetworkDependenciesEndpoint;
import com.azure.resourcemanager.kusto.models.SkuDescription;

public final class ClustersImpl
implements Clusters {
    private static final ClientLogger LOGGER = new ClientLogger(ClustersImpl.class);
    private final ClustersClient innerClient;
    private final KustoManager serviceManager;

    public ClustersImpl(ClustersClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Cluster> getByResourceGroupWithResponse(String resourceGroupName, String clusterName, Context context) {
        Response<ClusterInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, clusterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClusterImpl((ClusterInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Cluster getByResourceGroup(String resourceGroupName, String clusterName) {
        ClusterInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, clusterName);
        if (inner != null) {
            return new ClusterImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String clusterName) {
        this.serviceClient().delete(resourceGroupName, clusterName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, context);
    }

    @Override
    public void stop(String resourceGroupName, String clusterName) {
        this.serviceClient().stop(resourceGroupName, clusterName);
    }

    @Override
    public void stop(String resourceGroupName, String clusterName, Context context) {
        this.serviceClient().stop(resourceGroupName, clusterName, context);
    }

    @Override
    public void start(String resourceGroupName, String clusterName) {
        this.serviceClient().start(resourceGroupName, clusterName);
    }

    @Override
    public void start(String resourceGroupName, String clusterName, Context context) {
        this.serviceClient().start(resourceGroupName, clusterName, context);
    }

    @Override
    public void migrate(String resourceGroupName, String clusterName, ClusterMigrateRequest clusterMigrateRequest) {
        this.serviceClient().migrate(resourceGroupName, clusterName, clusterMigrateRequest);
    }

    @Override
    public void migrate(String resourceGroupName, String clusterName, ClusterMigrateRequest clusterMigrateRequest, Context context) {
        this.serviceClient().migrate(resourceGroupName, clusterName, clusterMigrateRequest, context);
    }

    @Override
    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases(String resourceGroupName, String clusterName) {
        PagedIterable<FollowerDatabaseDefinitionInner> inner = this.serviceClient().listFollowerDatabases(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FollowerDatabaseDefinitionImpl((FollowerDatabaseDefinitionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<FollowerDatabaseDefinitionInner> inner = this.serviceClient().listFollowerDatabases(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new FollowerDatabaseDefinitionImpl((FollowerDatabaseDefinitionInner)inner1, this.manager()));
    }

    @Override
    public void detachFollowerDatabases(String resourceGroupName, String clusterName, FollowerDatabaseDefinitionInner followerDatabaseToRemove) {
        this.serviceClient().detachFollowerDatabases(resourceGroupName, clusterName, followerDatabaseToRemove);
    }

    @Override
    public void detachFollowerDatabases(String resourceGroupName, String clusterName, FollowerDatabaseDefinitionInner followerDatabaseToRemove, Context context) {
        this.serviceClient().detachFollowerDatabases(resourceGroupName, clusterName, followerDatabaseToRemove, context);
    }

    @Override
    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork(String resourceGroupName, String clusterName) {
        DiagnoseVirtualNetworkResultInner inner = this.serviceClient().diagnoseVirtualNetwork(resourceGroupName, clusterName);
        if (inner != null) {
            return new DiagnoseVirtualNetworkResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork(String resourceGroupName, String clusterName, Context context) {
        DiagnoseVirtualNetworkResultInner inner = this.serviceClient().diagnoseVirtualNetwork(resourceGroupName, clusterName, context);
        if (inner != null) {
            return new DiagnoseVirtualNetworkResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Cluster> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ClusterInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> list() {
        PagedIterable<ClusterInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Cluster> list(Context context) {
        PagedIterable<ClusterInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterImpl((ClusterInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<SkuDescription> listSkus() {
        PagedIterable<SkuDescriptionInner> inner = this.serviceClient().listSkus();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuDescriptionImpl((SkuDescriptionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<SkuDescription> listSkus(Context context) {
        PagedIterable<SkuDescriptionInner> inner = this.serviceClient().listSkus(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new SkuDescriptionImpl((SkuDescriptionInner)inner1, this.manager()));
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String location, ClusterCheckNameRequest clusterName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(location, clusterName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String location, ClusterCheckNameRequest clusterName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(location, clusterName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<AzureResourceSku> listSkusByResource(String resourceGroupName, String clusterName) {
        PagedIterable<AzureResourceSkuInner> inner = this.serviceClient().listSkusByResource(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureResourceSkuImpl((AzureResourceSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<AzureResourceSku> listSkusByResource(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<AzureResourceSkuInner> inner = this.serviceClient().listSkusByResource(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new AzureResourceSkuImpl((AzureResourceSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OutboundNetworkDependenciesEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String clusterName) {
        PagedIterable<OutboundNetworkDependenciesEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundNetworkDependenciesEndpointImpl((OutboundNetworkDependenciesEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OutboundNetworkDependenciesEndpoint> listOutboundNetworkDependenciesEndpoints(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<OutboundNetworkDependenciesEndpointInner> inner = this.serviceClient().listOutboundNetworkDependenciesEndpoints(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OutboundNetworkDependenciesEndpointImpl((OutboundNetworkDependenciesEndpointInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LanguageExtension> listLanguageExtensions(String resourceGroupName, String clusterName) {
        PagedIterable<LanguageExtensionInner> inner = this.serviceClient().listLanguageExtensions(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LanguageExtensionImpl((LanguageExtensionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<LanguageExtension> listLanguageExtensions(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<LanguageExtensionInner> inner = this.serviceClient().listLanguageExtensions(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new LanguageExtensionImpl((LanguageExtensionInner)inner1, this.manager()));
    }

    @Override
    public void addLanguageExtensions(String resourceGroupName, String clusterName, LanguageExtensionsList languageExtensionsToAdd) {
        this.serviceClient().addLanguageExtensions(resourceGroupName, clusterName, languageExtensionsToAdd);
    }

    @Override
    public void addLanguageExtensions(String resourceGroupName, String clusterName, LanguageExtensionsList languageExtensionsToAdd, Context context) {
        this.serviceClient().addLanguageExtensions(resourceGroupName, clusterName, languageExtensionsToAdd, context);
    }

    @Override
    public void removeLanguageExtensions(String resourceGroupName, String clusterName, LanguageExtensionsList languageExtensionsToRemove) {
        this.serviceClient().removeLanguageExtensions(resourceGroupName, clusterName, languageExtensionsToRemove);
    }

    @Override
    public void removeLanguageExtensions(String resourceGroupName, String clusterName, LanguageExtensionsList languageExtensionsToRemove, Context context) {
        this.serviceClient().removeLanguageExtensions(resourceGroupName, clusterName, languageExtensionsToRemove, context);
    }

    @Override
    public Cluster getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        return (Cluster)this.getByResourceGroupWithResponse(resourceGroupName, clusterName, Context.NONE).getValue();
    }

    @Override
    public Response<Cluster> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, clusterName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        this.delete(resourceGroupName, clusterName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        this.delete(resourceGroupName, clusterName, context);
    }

    private ClustersClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterImpl define(String name) {
        return new ClusterImpl(name, this.manager());
    }
}

