/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.DatabasesClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.DatabaseInner;
import com.azure.resourcemanager.kusto.fluent.models.DatabasePrincipalInner;
import com.azure.resourcemanager.kusto.fluent.models.DatabasePrincipalListResultInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.DatabaseImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasePrincipalImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasePrincipalListResultImpl;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.models.CallerRole;
import com.azure.resourcemanager.kusto.models.CheckNameRequest;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.Database;
import com.azure.resourcemanager.kusto.models.DatabasePrincipal;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalListRequest;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalListResult;
import com.azure.resourcemanager.kusto.models.Databases;

public final class DatabasesImpl
implements Databases {
    private static final ClientLogger LOGGER = new ClientLogger(DatabasesImpl.class);
    private final DatabasesClient innerClient;
    private final KustoManager serviceManager;

    public DatabasesImpl(DatabasesClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, CheckNameRequest resourceName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, CheckNameRequest resourceName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, resourceName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<Database> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<DatabaseInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseImpl((DatabaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Database> listByCluster(String resourceGroupName, String clusterName, Integer top, String skiptoken, Context context) {
        PagedIterable<DatabaseInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, top, skiptoken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabaseImpl((DatabaseInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Database> getWithResponse(String resourceGroupName, String clusterName, String databaseName, Context context) {
        Response<DatabaseInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, databaseName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseImpl((DatabaseInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Database get(String resourceGroupName, String clusterName, String databaseName) {
        DatabaseInner inner = this.serviceClient().get(resourceGroupName, clusterName, databaseName);
        if (inner != null) {
            return new DatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Database createOrUpdate(String resourceGroupName, String clusterName, String databaseName, DatabaseInner parameters) {
        DatabaseInner inner = this.serviceClient().createOrUpdate(resourceGroupName, clusterName, databaseName, parameters);
        if (inner != null) {
            return new DatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Database createOrUpdate(String resourceGroupName, String clusterName, String databaseName, DatabaseInner parameters, CallerRole callerRole, Context context) {
        DatabaseInner inner = this.serviceClient().createOrUpdate(resourceGroupName, clusterName, databaseName, parameters, callerRole, context);
        if (inner != null) {
            return new DatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Database update(String resourceGroupName, String clusterName, String databaseName, DatabaseInner parameters) {
        DatabaseInner inner = this.serviceClient().update(resourceGroupName, clusterName, databaseName, parameters);
        if (inner != null) {
            return new DatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Database update(String resourceGroupName, String clusterName, String databaseName, DatabaseInner parameters, CallerRole callerRole, Context context) {
        DatabaseInner inner = this.serviceClient().update(resourceGroupName, clusterName, databaseName, parameters, callerRole, context);
        if (inner != null) {
            return new DatabaseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, context);
    }

    @Override
    public PagedIterable<DatabasePrincipal> listPrincipals(String resourceGroupName, String clusterName, String databaseName) {
        PagedIterable<DatabasePrincipalInner> inner = this.serviceClient().listPrincipals(resourceGroupName, clusterName, databaseName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabasePrincipalImpl((DatabasePrincipalInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DatabasePrincipal> listPrincipals(String resourceGroupName, String clusterName, String databaseName, Context context) {
        PagedIterable<DatabasePrincipalInner> inner = this.serviceClient().listPrincipals(resourceGroupName, clusterName, databaseName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DatabasePrincipalImpl((DatabasePrincipalInner)inner1, this.manager()));
    }

    @Override
    public Response<DatabasePrincipalListResult> addPrincipalsWithResponse(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalListRequest databasePrincipalsToAdd, Context context) {
        Response<DatabasePrincipalListResultInner> inner = this.serviceClient().addPrincipalsWithResponse(resourceGroupName, clusterName, databaseName, databasePrincipalsToAdd, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabasePrincipalListResultImpl((DatabasePrincipalListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DatabasePrincipalListResult addPrincipals(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalListRequest databasePrincipalsToAdd) {
        DatabasePrincipalListResultInner inner = this.serviceClient().addPrincipals(resourceGroupName, clusterName, databaseName, databasePrincipalsToAdd);
        if (inner != null) {
            return new DatabasePrincipalListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<DatabasePrincipalListResult> removePrincipalsWithResponse(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalListRequest databasePrincipalsToRemove, Context context) {
        Response<DatabasePrincipalListResultInner> inner = this.serviceClient().removePrincipalsWithResponse(resourceGroupName, clusterName, databaseName, databasePrincipalsToRemove, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabasePrincipalListResultImpl((DatabasePrincipalListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DatabasePrincipalListResult removePrincipals(String resourceGroupName, String clusterName, String databaseName, DatabasePrincipalListRequest databasePrincipalsToRemove) {
        DatabasePrincipalListResultInner inner = this.serviceClient().removePrincipals(resourceGroupName, clusterName, databaseName, databasePrincipalsToRemove);
        if (inner != null) {
            return new DatabasePrincipalListResultImpl(inner, this.manager());
        }
        return null;
    }

    private DatabasesClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }
}

