/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.kusto.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.kusto.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.models.PrivateLinkResource;
import com.azure.resourcemanager.kusto.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final KustoManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String clusterName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String clusterName, String privateLinkResourceName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, privateLinkResourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String clusterName, String privateLinkResourceName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, clusterName, privateLinkResourceName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }
}

