/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.SandboxCustomImageInner;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.models.Language;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.SandboxCustomImage;

public final class SandboxCustomImageImpl
implements SandboxCustomImage,
SandboxCustomImage.Definition,
SandboxCustomImage.Update {
    private SandboxCustomImageInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String sandboxCustomImageName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Language language() {
        return this.innerModel().language();
    }

    @Override
    public String languageVersion() {
        return this.innerModel().languageVersion();
    }

    @Override
    public String requirementsFileContent() {
        return this.innerModel().requirementsFileContent();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SandboxCustomImageInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public SandboxCustomImageImpl withExistingCluster(String resourceGroupName, String clusterName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public SandboxCustomImage create() {
        this.innerObject = this.serviceManager.serviceClient().getSandboxCustomImages().createOrUpdate(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SandboxCustomImage create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSandboxCustomImages().createOrUpdate(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, this.innerModel(), context);
        return this;
    }

    SandboxCustomImageImpl(String name, KustoManager serviceManager) {
        this.innerObject = new SandboxCustomImageInner();
        this.serviceManager = serviceManager;
        this.sandboxCustomImageName = name;
    }

    @Override
    public SandboxCustomImageImpl update() {
        return this;
    }

    @Override
    public SandboxCustomImage apply() {
        this.innerObject = this.serviceManager.serviceClient().getSandboxCustomImages().update(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SandboxCustomImage apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSandboxCustomImages().update(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, this.innerModel(), context);
        return this;
    }

    SandboxCustomImageImpl(SandboxCustomImageInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
        this.sandboxCustomImageName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sandboxCustomImages");
    }

    @Override
    public SandboxCustomImage refresh() {
        this.innerObject = (SandboxCustomImageInner)((Object)this.serviceManager.serviceClient().getSandboxCustomImages().getWithResponse(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SandboxCustomImage refresh(Context context) {
        this.innerObject = (SandboxCustomImageInner)((Object)this.serviceManager.serviceClient().getSandboxCustomImages().getWithResponse(this.resourceGroupName, this.clusterName, this.sandboxCustomImageName, context).getValue());
        return this;
    }

    @Override
    public SandboxCustomImageImpl withLanguage(Language language) {
        this.innerModel().withLanguage(language);
        return this;
    }

    @Override
    public SandboxCustomImageImpl withLanguageVersion(String languageVersion) {
        this.innerModel().withLanguageVersion(languageVersion);
        return this;
    }

    @Override
    public SandboxCustomImageImpl withRequirementsFileContent(String requirementsFileContent) {
        this.innerModel().withRequirementsFileContent(requirementsFileContent);
        return this;
    }
}

