/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.models.ScriptInner;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.Script;

public final class ScriptImpl
implements Script,
Script.Definition,
Script.Update {
    private ScriptInner innerObject;
    private final KustoManager serviceManager;
    private String resourceGroupName;
    private String clusterName;
    private String databaseName;
    private String scriptName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String scriptUrl() {
        return this.innerModel().scriptUrl();
    }

    @Override
    public String scriptUrlSasToken() {
        return this.innerModel().scriptUrlSasToken();
    }

    @Override
    public String scriptContent() {
        return this.innerModel().scriptContent();
    }

    @Override
    public String forceUpdateTag() {
        return this.innerModel().forceUpdateTag();
    }

    @Override
    public Boolean continueOnErrors() {
        return this.innerModel().continueOnErrors();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ScriptInner innerModel() {
        return this.innerObject;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScriptImpl withExistingDatabase(String resourceGroupName, String clusterName, String databaseName) {
        this.resourceGroupName = resourceGroupName;
        this.clusterName = clusterName;
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public Script create() {
        this.innerObject = this.serviceManager.serviceClient().getScripts().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Script create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getScripts().createOrUpdate(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, this.innerModel(), context);
        return this;
    }

    ScriptImpl(String name, KustoManager serviceManager) {
        this.innerObject = new ScriptInner();
        this.serviceManager = serviceManager;
        this.scriptName = name;
    }

    @Override
    public ScriptImpl update() {
        return this;
    }

    @Override
    public Script apply() {
        this.innerObject = this.serviceManager.serviceClient().getScripts().update(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Script apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getScripts().update(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, this.innerModel(), context);
        return this;
    }

    ScriptImpl(ScriptInner innerObject, KustoManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.clusterName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "clusters");
        this.databaseName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databases");
        this.scriptName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "scripts");
    }

    @Override
    public Script refresh() {
        this.innerObject = (ScriptInner)((Object)this.serviceManager.serviceClient().getScripts().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Script refresh(Context context) {
        this.innerObject = (ScriptInner)((Object)this.serviceManager.serviceClient().getScripts().getWithResponse(this.resourceGroupName, this.clusterName, this.databaseName, this.scriptName, context).getValue());
        return this;
    }

    @Override
    public ScriptImpl withScriptUrl(String scriptUrl) {
        this.innerModel().withScriptUrl(scriptUrl);
        return this;
    }

    @Override
    public ScriptImpl withScriptUrlSasToken(String scriptUrlSasToken) {
        this.innerModel().withScriptUrlSasToken(scriptUrlSasToken);
        return this;
    }

    @Override
    public ScriptImpl withScriptContent(String scriptContent) {
        this.innerModel().withScriptContent(scriptContent);
        return this;
    }

    @Override
    public ScriptImpl withForceUpdateTag(String forceUpdateTag) {
        this.innerModel().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    @Override
    public ScriptImpl withContinueOnErrors(Boolean continueOnErrors) {
        this.innerModel().withContinueOnErrors(continueOnErrors);
        return this;
    }
}

