/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.kusto.fluent.ScriptsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.ScriptInner;
import com.azure.resourcemanager.kusto.implementation.KustoManagementClientImpl;
import com.azure.resourcemanager.kusto.models.ScriptCheckNameRequest;
import com.azure.resourcemanager.kusto.models.ScriptListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ScriptsClientImpl
implements ScriptsClient {
    private final ScriptsService service;
    private final KustoManagementClientImpl client;

    ScriptsClientImpl(KustoManagementClientImpl client) {
        this.service = (ScriptsService)RestProxy.create(ScriptsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScriptInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String clusterName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScriptListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ScriptInner>> listByDatabaseSinglePageAsync(String resourceGroupName, String clusterName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ScriptListResult)res.getValue()).value(), null, null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ScriptInner> listByDatabaseAsync(String resourceGroupName, String clusterName, String databaseName) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, clusterName, databaseName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ScriptInner> listByDatabaseAsync(String resourceGroupName, String clusterName, String databaseName, Context context) {
        return new PagedFlux(() -> this.listByDatabaseSinglePageAsync(resourceGroupName, clusterName, databaseName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScriptInner> listByDatabase(String resourceGroupName, String clusterName, String databaseName) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, clusterName, databaseName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ScriptInner> listByDatabase(String resourceGroupName, String clusterName, String databaseName, Context context) {
        return new PagedIterable(this.listByDatabaseAsync(resourceGroupName, clusterName, databaseName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScriptInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ScriptInner>> getWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScriptInner> getAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        return this.getWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ScriptInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ScriptInner> getWithResponse(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScriptInner get(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        return (ScriptInner)((Object)this.getWithResponse(resourceGroupName, clusterName, databaseName, scriptName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScriptInner>, ScriptInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ScriptInner.class), (Type)((Object)ScriptInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScriptInner>, ScriptInner> beginCreateOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ScriptInner.class), (Type)((Object)ScriptInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScriptInner>, ScriptInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScriptInner>, ScriptInner> beginCreateOrUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScriptInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScriptInner> createOrUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScriptInner createOrUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return (ScriptInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScriptInner createOrUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return (ScriptInner)((Object)this.createOrUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScriptInner>, ScriptInner> beginUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ScriptInner.class), (Type)((Object)ScriptInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ScriptInner>, ScriptInner> beginUpdateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ScriptInner.class), (Type)((Object)ScriptInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScriptInner>, ScriptInner> beginUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ScriptInner>, ScriptInner> beginUpdate(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScriptInner> updateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ScriptInner> updateAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScriptInner update(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters) {
        return (ScriptInner)((Object)this.updateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ScriptInner update(String resourceGroupName, String clusterName, String databaseName, String scriptName, ScriptInner parameters, Context context) {
        return (ScriptInner)((Object)this.updateAsync(resourceGroupName, clusterName, databaseName, scriptName, parameters, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName, databaseName, scriptName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, scriptName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, scriptName, context).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, scriptName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, databaseName, scriptName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        this.deleteAsync(resourceGroupName, clusterName, databaseName, scriptName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        this.deleteAsync(resourceGroupName, clusterName, databaseName, scriptName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        scriptName.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), scriptName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckNameResultInner>> checkNameAvailabilityWithResponseAsync(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (scriptName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scriptName is required and cannot be null."));
        }
        scriptName.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkNameAvailability(this.client.getEndpoint(), resourceGroupName, clusterName, databaseName, this.client.getApiVersion(), this.client.getSubscriptionId(), scriptName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CheckNameResultInner> checkNameAvailabilityAsync(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName) {
        return this.checkNameAvailabilityWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName).flatMap(res -> Mono.justOrEmpty((Object)((CheckNameResultInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameResultInner> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName, Context context) {
        return (Response)this.checkNameAvailabilityWithResponseAsync(resourceGroupName, clusterName, databaseName, scriptName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameResultInner checkNameAvailability(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName) {
        return (CheckNameResultInner)this.checkNameAvailabilityWithResponse(resourceGroupName, clusterName, databaseName, scriptName, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KustoManagementClien")
    public static interface ScriptsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScriptListResult>> listByDatabase(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ScriptInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="scriptName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="scriptName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ScriptInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="scriptName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") ScriptInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scripts/{scriptName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="clusterName") String var4, @PathParam(value="databaseName") String var5, @PathParam(value="scriptName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Kusto/clusters/{clusterName}/databases/{databaseName}/scriptsCheckNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckNameResultInner>> checkNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="clusterName") String var3, @PathParam(value="databaseName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") ScriptCheckNameRequest var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

