/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.KustoManager;
import com.azure.resourcemanager.kusto.fluent.ScriptsClient;
import com.azure.resourcemanager.kusto.fluent.models.CheckNameResultInner;
import com.azure.resourcemanager.kusto.fluent.models.ScriptInner;
import com.azure.resourcemanager.kusto.implementation.CheckNameResultImpl;
import com.azure.resourcemanager.kusto.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.kusto.implementation.ScriptImpl;
import com.azure.resourcemanager.kusto.models.CheckNameResult;
import com.azure.resourcemanager.kusto.models.Script;
import com.azure.resourcemanager.kusto.models.ScriptCheckNameRequest;
import com.azure.resourcemanager.kusto.models.Scripts;

public final class ScriptsImpl
implements Scripts {
    private static final ClientLogger LOGGER = new ClientLogger(ScriptsImpl.class);
    private final ScriptsClient innerClient;
    private final KustoManager serviceManager;

    public ScriptsImpl(ScriptsClient innerClient, KustoManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Script> listByDatabase(String resourceGroupName, String clusterName, String databaseName) {
        PagedIterable<ScriptInner> inner = this.serviceClient().listByDatabase(resourceGroupName, clusterName, databaseName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScriptImpl((ScriptInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Script> listByDatabase(String resourceGroupName, String clusterName, String databaseName, Context context) {
        PagedIterable<ScriptInner> inner = this.serviceClient().listByDatabase(resourceGroupName, clusterName, databaseName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ScriptImpl((ScriptInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Script> getWithResponse(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        Response<ScriptInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, databaseName, scriptName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ScriptImpl((ScriptInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Script get(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        ScriptInner inner = this.serviceClient().get(resourceGroupName, clusterName, databaseName, scriptName);
        if (inner != null) {
            return new ScriptImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String scriptName) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, scriptName);
    }

    @Override
    public void delete(String resourceGroupName, String clusterName, String databaseName, String scriptName, Context context) {
        this.serviceClient().delete(resourceGroupName, clusterName, databaseName, scriptName, context);
    }

    @Override
    public Response<CheckNameResult> checkNameAvailabilityWithResponse(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName, Context context) {
        Response<CheckNameResultInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(resourceGroupName, clusterName, databaseName, scriptName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CheckNameResultImpl((CheckNameResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public CheckNameResult checkNameAvailability(String resourceGroupName, String clusterName, String databaseName, ScriptCheckNameRequest scriptName) {
        CheckNameResultInner inner = this.serviceClient().checkNameAvailability(resourceGroupName, clusterName, databaseName, scriptName);
        if (inner != null) {
            return new CheckNameResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Script getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String scriptName = ResourceManagerUtils.getValueFromIdByName(id, "scripts");
        if (scriptName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scripts'.", id)));
        }
        return (Script)this.getWithResponse(resourceGroupName, clusterName, databaseName, scriptName, Context.NONE).getValue();
    }

    @Override
    public Response<Script> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String scriptName = ResourceManagerUtils.getValueFromIdByName(id, "scripts");
        if (scriptName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scripts'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, databaseName, scriptName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String scriptName = ResourceManagerUtils.getValueFromIdByName(id, "scripts");
        if (scriptName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scripts'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, scriptName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String databaseName = ResourceManagerUtils.getValueFromIdByName(id, "databases");
        if (databaseName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databases'.", id)));
        }
        String scriptName = ResourceManagerUtils.getValueFromIdByName(id, "scripts");
        if (scriptName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'scripts'.", id)));
        }
        this.delete(resourceGroupName, clusterName, databaseName, scriptName, context);
    }

    private ScriptsClient serviceClient() {
        return this.innerClient;
    }

    private KustoManager manager() {
        return this.serviceManager;
    }

    @Override
    public ScriptImpl define(String name) {
        return new ScriptImpl(name, this.manager());
    }
}

