/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.Type;
import java.io.IOException;

public final class CheckNameRequest
implements JsonSerializable<CheckNameRequest> {
    private String name;
    private Type type;
    private static final ClientLogger LOGGER = new ClientLogger(CheckNameRequest.class);

    public String name() {
        return this.name;
    }

    public CheckNameRequest withName(String name) {
        this.name = name;
        return this;
    }

    public Type type() {
        return this.type;
    }

    public CheckNameRequest withType(Type type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CheckNameRequest"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model CheckNameRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static CheckNameRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CheckNameRequest)jsonReader.readObject(reader -> {
            CheckNameRequest deserializedCheckNameRequest = new CheckNameRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCheckNameRequest.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCheckNameRequest.type = Type.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckNameRequest;
        });
    }
}

