/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.kusto.fluent.models.ClusterInner;
import com.azure.resourcemanager.kusto.fluent.models.FollowerDatabaseDefinitionInner;
import com.azure.resourcemanager.kusto.models.AcceptedAudiences;
import com.azure.resourcemanager.kusto.models.AzureSku;
import com.azure.resourcemanager.kusto.models.ClusterMigrateRequest;
import com.azure.resourcemanager.kusto.models.ClusterNetworkAccessFlag;
import com.azure.resourcemanager.kusto.models.DiagnoseVirtualNetworkResult;
import com.azure.resourcemanager.kusto.models.EngineType;
import com.azure.resourcemanager.kusto.models.FollowerDatabaseDefinition;
import com.azure.resourcemanager.kusto.models.Identity;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.LanguageExtension;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.MigrationClusterProperties;
import com.azure.resourcemanager.kusto.models.OptimizedAutoscale;
import com.azure.resourcemanager.kusto.models.PrivateEndpointConnection;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.PublicIpType;
import com.azure.resourcemanager.kusto.models.PublicNetworkAccess;
import com.azure.resourcemanager.kusto.models.State;
import com.azure.resourcemanager.kusto.models.TrustedExternalTenant;
import com.azure.resourcemanager.kusto.models.VirtualNetworkConfiguration;
import java.util.List;
import java.util.Map;

public interface Cluster {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public AzureSku sku();

    public SystemData systemData();

    public List<String> zones();

    public Identity identity();

    public String etag();

    public State state();

    public ProvisioningState provisioningState();

    public String uri();

    public String dataIngestionUri();

    public String stateReason();

    public List<TrustedExternalTenant> trustedExternalTenants();

    public OptimizedAutoscale optimizedAutoscale();

    public Boolean enableDiskEncryption();

    public Boolean enableStreamingIngest();

    public VirtualNetworkConfiguration virtualNetworkConfiguration();

    public KeyVaultProperties keyVaultProperties();

    public Boolean enablePurge();

    public LanguageExtensionsList languageExtensions();

    public Boolean enableDoubleEncryption();

    public PublicNetworkAccess publicNetworkAccess();

    public List<String> allowedIpRangeList();

    public EngineType engineType();

    public List<AcceptedAudiences> acceptedAudiences();

    public Boolean enableAutoStop();

    public ClusterNetworkAccessFlag restrictOutboundNetworkAccess();

    public List<String> allowedFqdnList();

    public PublicIpType publicIpType();

    public String virtualClusterGraduationProperties();

    public List<PrivateEndpointConnection> privateEndpointConnections();

    public MigrationClusterProperties migrationCluster();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ClusterInner innerModel();

    public Update update();

    public Cluster refresh();

    public Cluster refresh(Context var1);

    public void stop();

    public void stop(Context var1);

    public void start();

    public void start(Context var1);

    public void migrate(ClusterMigrateRequest var1);

    public void migrate(ClusterMigrateRequest var1, Context var2);

    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases();

    public PagedIterable<FollowerDatabaseDefinition> listFollowerDatabases(Context var1);

    public void detachFollowerDatabases(FollowerDatabaseDefinitionInner var1);

    public void detachFollowerDatabases(FollowerDatabaseDefinitionInner var1, Context var2);

    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork();

    public DiagnoseVirtualNetworkResult diagnoseVirtualNetwork(Context var1);

    public PagedIterable<LanguageExtension> listLanguageExtensions();

    public PagedIterable<LanguageExtension> listLanguageExtensions(Context var1);

    public void addLanguageExtensions(LanguageExtensionsList var1);

    public void addLanguageExtensions(LanguageExtensionsList var1, Context var2);

    public void removeLanguageExtensions(LanguageExtensionsList var1);

    public void removeLanguageExtensions(LanguageExtensionsList var1, Context var2);

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithPublicIpType {
            public Update withPublicIpType(PublicIpType var1);
        }

        public static interface WithAllowedFqdnList {
            public Update withAllowedFqdnList(List<String> var1);
        }

        public static interface WithRestrictOutboundNetworkAccess {
            public Update withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag var1);
        }

        public static interface WithEnableAutoStop {
            public Update withEnableAutoStop(Boolean var1);
        }

        public static interface WithAcceptedAudiences {
            public Update withAcceptedAudiences(List<AcceptedAudiences> var1);
        }

        public static interface WithEngineType {
            public Update withEngineType(EngineType var1);
        }

        public static interface WithAllowedIpRangeList {
            public Update withAllowedIpRangeList(List<String> var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithEnableDoubleEncryption {
            public Update withEnableDoubleEncryption(Boolean var1);
        }

        public static interface WithLanguageExtensions {
            public Update withLanguageExtensions(LanguageExtensionsList var1);
        }

        public static interface WithEnablePurge {
            public Update withEnablePurge(Boolean var1);
        }

        public static interface WithKeyVaultProperties {
            public Update withKeyVaultProperties(KeyVaultProperties var1);
        }

        public static interface WithVirtualNetworkConfiguration {
            public Update withVirtualNetworkConfiguration(VirtualNetworkConfiguration var1);
        }

        public static interface WithEnableStreamingIngest {
            public Update withEnableStreamingIngest(Boolean var1);
        }

        public static interface WithEnableDiskEncryption {
            public Update withEnableDiskEncryption(Boolean var1);
        }

        public static interface WithOptimizedAutoscale {
            public Update withOptimizedAutoscale(OptimizedAutoscale var1);
        }

        public static interface WithTrustedExternalTenants {
            public Update withTrustedExternalTenants(List<TrustedExternalTenant> var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(Identity var1);
        }

        public static interface WithZones {
            public Update withZones(List<String> var1);
        }

        public static interface WithSku {
            public Update withSku(AzureSku var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithSku,
    UpdateStages.WithZones,
    UpdateStages.WithIdentity,
    UpdateStages.WithTrustedExternalTenants,
    UpdateStages.WithOptimizedAutoscale,
    UpdateStages.WithEnableDiskEncryption,
    UpdateStages.WithEnableStreamingIngest,
    UpdateStages.WithVirtualNetworkConfiguration,
    UpdateStages.WithKeyVaultProperties,
    UpdateStages.WithEnablePurge,
    UpdateStages.WithLanguageExtensions,
    UpdateStages.WithEnableDoubleEncryption,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithAllowedIpRangeList,
    UpdateStages.WithEngineType,
    UpdateStages.WithAcceptedAudiences,
    UpdateStages.WithEnableAutoStop,
    UpdateStages.WithRestrictOutboundNetworkAccess,
    UpdateStages.WithAllowedFqdnList,
    UpdateStages.WithPublicIpType,
    UpdateStages.WithIfMatch {
        public Cluster apply();

        public Cluster apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithVirtualClusterGraduationProperties {
            public WithCreate withVirtualClusterGraduationProperties(String var1);
        }

        public static interface WithPublicIpType {
            public WithCreate withPublicIpType(PublicIpType var1);
        }

        public static interface WithAllowedFqdnList {
            public WithCreate withAllowedFqdnList(List<String> var1);
        }

        public static interface WithRestrictOutboundNetworkAccess {
            public WithCreate withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag var1);
        }

        public static interface WithEnableAutoStop {
            public WithCreate withEnableAutoStop(Boolean var1);
        }

        public static interface WithAcceptedAudiences {
            public WithCreate withAcceptedAudiences(List<AcceptedAudiences> var1);
        }

        public static interface WithEngineType {
            public WithCreate withEngineType(EngineType var1);
        }

        public static interface WithAllowedIpRangeList {
            public WithCreate withAllowedIpRangeList(List<String> var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithEnableDoubleEncryption {
            public WithCreate withEnableDoubleEncryption(Boolean var1);
        }

        public static interface WithLanguageExtensions {
            public WithCreate withLanguageExtensions(LanguageExtensionsList var1);
        }

        public static interface WithEnablePurge {
            public WithCreate withEnablePurge(Boolean var1);
        }

        public static interface WithKeyVaultProperties {
            public WithCreate withKeyVaultProperties(KeyVaultProperties var1);
        }

        public static interface WithVirtualNetworkConfiguration {
            public WithCreate withVirtualNetworkConfiguration(VirtualNetworkConfiguration var1);
        }

        public static interface WithEnableStreamingIngest {
            public WithCreate withEnableStreamingIngest(Boolean var1);
        }

        public static interface WithEnableDiskEncryption {
            public WithCreate withEnableDiskEncryption(Boolean var1);
        }

        public static interface WithOptimizedAutoscale {
            public WithCreate withOptimizedAutoscale(OptimizedAutoscale var1);
        }

        public static interface WithTrustedExternalTenants {
            public WithCreate withTrustedExternalTenants(List<TrustedExternalTenant> var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(Identity var1);
        }

        public static interface WithZones {
            public WithCreate withZones(List<String> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithZones,
        WithIdentity,
        WithTrustedExternalTenants,
        WithOptimizedAutoscale,
        WithEnableDiskEncryption,
        WithEnableStreamingIngest,
        WithVirtualNetworkConfiguration,
        WithKeyVaultProperties,
        WithEnablePurge,
        WithLanguageExtensions,
        WithEnableDoubleEncryption,
        WithPublicNetworkAccess,
        WithAllowedIpRangeList,
        WithEngineType,
        WithAcceptedAudiences,
        WithEnableAutoStop,
        WithRestrictOutboundNetworkAccess,
        WithAllowedFqdnList,
        WithPublicIpType,
        WithVirtualClusterGraduationProperties,
        WithIfMatch,
        WithIfNoneMatch {
            public Cluster create();

            public Cluster create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(AzureSku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

