/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.CosmosDbDataConnectionProperties;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.models.DataConnectionKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class CosmosDbDataConnection
extends DataConnectionInner {
    private DataConnectionKind kind = DataConnectionKind.COSMOS_DB;
    private CosmosDbDataConnectionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public DataConnectionKind kind() {
        return this.kind;
    }

    private CosmosDbDataConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public CosmosDbDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public CosmosDbDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public CosmosDbDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public String managedIdentityResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityResourceId();
    }

    public CosmosDbDataConnection withManagedIdentityResourceId(String managedIdentityResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withManagedIdentityResourceId(managedIdentityResourceId);
        return this;
    }

    public String managedIdentityObjectId() {
        return this.innerProperties() == null ? null : this.innerProperties().managedIdentityObjectId();
    }

    public String cosmosDbAccountResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbAccountResourceId();
    }

    public CosmosDbDataConnection withCosmosDbAccountResourceId(String cosmosDbAccountResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbAccountResourceId(cosmosDbAccountResourceId);
        return this;
    }

    public String cosmosDbDatabase() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbDatabase();
    }

    public CosmosDbDataConnection withCosmosDbDatabase(String cosmosDbDatabase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbDatabase(cosmosDbDatabase);
        return this;
    }

    public String cosmosDbContainer() {
        return this.innerProperties() == null ? null : this.innerProperties().cosmosDbContainer();
    }

    public CosmosDbDataConnection withCosmosDbContainer(String cosmosDbContainer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withCosmosDbContainer(cosmosDbContainer);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public CosmosDbDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CosmosDbDataConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbDataConnection fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbDataConnection)((Object)jsonReader.readObject(reader -> {
            CosmosDbDataConnection deserializedCosmosDbDataConnection = new CosmosDbDataConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.withLocation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.kind = DataConnectionKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCosmosDbDataConnection.innerProperties = CosmosDbDataConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCosmosDbDataConnection;
        }));
    }
}

