/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.DataConnectionInner;
import com.azure.resourcemanager.kusto.fluent.models.IotHubConnectionProperties;
import com.azure.resourcemanager.kusto.models.DataConnectionKind;
import com.azure.resourcemanager.kusto.models.DatabaseRouting;
import com.azure.resourcemanager.kusto.models.IotHubDataFormat;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class IotHubDataConnection
extends DataConnectionInner {
    private DataConnectionKind kind = DataConnectionKind.IOT_HUB;
    private IotHubConnectionProperties innerProperties;
    private String type;
    private String name;
    private String id;

    @Override
    public DataConnectionKind kind() {
        return this.kind;
    }

    private IotHubConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public IotHubDataConnection withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public String iotHubResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().iotHubResourceId();
    }

    public IotHubDataConnection withIotHubResourceId(String iotHubResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withIotHubResourceId(iotHubResourceId);
        return this;
    }

    public String consumerGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().consumerGroup();
    }

    public IotHubDataConnection withConsumerGroup(String consumerGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withConsumerGroup(consumerGroup);
        return this;
    }

    public String tableName() {
        return this.innerProperties() == null ? null : this.innerProperties().tableName();
    }

    public IotHubDataConnection withTableName(String tableName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withTableName(tableName);
        return this;
    }

    public String mappingRuleName() {
        return this.innerProperties() == null ? null : this.innerProperties().mappingRuleName();
    }

    public IotHubDataConnection withMappingRuleName(String mappingRuleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withMappingRuleName(mappingRuleName);
        return this;
    }

    public IotHubDataFormat dataFormat() {
        return this.innerProperties() == null ? null : this.innerProperties().dataFormat();
    }

    public IotHubDataConnection withDataFormat(IotHubDataFormat dataFormat) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withDataFormat(dataFormat);
        return this;
    }

    public List<String> eventSystemProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().eventSystemProperties();
    }

    public IotHubDataConnection withEventSystemProperties(List<String> eventSystemProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withEventSystemProperties(eventSystemProperties);
        return this;
    }

    public String sharedAccessPolicyName() {
        return this.innerProperties() == null ? null : this.innerProperties().sharedAccessPolicyName();
    }

    public IotHubDataConnection withSharedAccessPolicyName(String sharedAccessPolicyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withSharedAccessPolicyName(sharedAccessPolicyName);
        return this;
    }

    public DatabaseRouting databaseRouting() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseRouting();
    }

    public IotHubDataConnection withDatabaseRouting(DatabaseRouting databaseRouting) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withDatabaseRouting(databaseRouting);
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.innerProperties() == null ? null : this.innerProperties().retrievalStartDate();
    }

    public IotHubDataConnection withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IotHubConnectionProperties();
        }
        this.innerProperties().withRetrievalStartDate(retrievalStartDate);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static IotHubDataConnection fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubDataConnection)((Object)jsonReader.readObject(reader -> {
            IotHubDataConnection deserializedIotHubDataConnection = new IotHubDataConnection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIotHubDataConnection.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIotHubDataConnection.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIotHubDataConnection.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIotHubDataConnection.withLocation(reader.getString());
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedIotHubDataConnection.kind = DataConnectionKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIotHubDataConnection.innerProperties = IotHubConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubDataConnection;
        }));
    }
}

