/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.fluent.models.SandboxCustomImageInner;
import java.io.IOException;
import java.util.List;

public final class SandboxCustomImagesListResult
implements JsonSerializable<SandboxCustomImagesListResult> {
    private String nextLink;
    private List<SandboxCustomImageInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public SandboxCustomImagesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<SandboxCustomImageInner> value() {
        return this.value;
    }

    public SandboxCustomImagesListResult withValue(List<SandboxCustomImageInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SandboxCustomImagesListResult fromJson(JsonReader jsonReader) throws IOException {
        return (SandboxCustomImagesListResult)jsonReader.readObject(reader -> {
            SandboxCustomImagesListResult deserializedSandboxCustomImagesListResult = new SandboxCustomImagesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedSandboxCustomImagesListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedSandboxCustomImagesListResult.value = value = reader.readArray(reader1 -> SandboxCustomImageInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSandboxCustomImagesListResult;
        });
    }
}

