/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.VnetState;
import java.io.IOException;

public final class VirtualNetworkConfiguration
implements JsonSerializable<VirtualNetworkConfiguration> {
    private String subnetId;
    private String enginePublicIpId;
    private String dataManagementPublicIpId;
    private VnetState state;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkConfiguration.class);

    public String subnetId() {
        return this.subnetId;
    }

    public VirtualNetworkConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String enginePublicIpId() {
        return this.enginePublicIpId;
    }

    public VirtualNetworkConfiguration withEnginePublicIpId(String enginePublicIpId) {
        this.enginePublicIpId = enginePublicIpId;
        return this;
    }

    public String dataManagementPublicIpId() {
        return this.dataManagementPublicIpId;
    }

    public VirtualNetworkConfiguration withDataManagementPublicIpId(String dataManagementPublicIpId) {
        this.dataManagementPublicIpId = dataManagementPublicIpId;
        return this;
    }

    public VnetState state() {
        return this.state;
    }

    public VirtualNetworkConfiguration withState(VnetState state) {
        this.state = state;
        return this;
    }

    public void validate() {
        if (this.subnetId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subnetId in model VirtualNetworkConfiguration"));
        }
        if (this.enginePublicIpId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property enginePublicIpId in model VirtualNetworkConfiguration"));
        }
        if (this.dataManagementPublicIpId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dataManagementPublicIpId in model VirtualNetworkConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("enginePublicIpId", this.enginePublicIpId);
        jsonWriter.writeStringField("dataManagementPublicIpId", this.dataManagementPublicIpId);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkConfiguration)jsonReader.readObject(reader -> {
            VirtualNetworkConfiguration deserializedVirtualNetworkConfiguration = new VirtualNetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subnetId".equals(fieldName)) {
                    deserializedVirtualNetworkConfiguration.subnetId = reader.getString();
                    continue;
                }
                if ("enginePublicIpId".equals(fieldName)) {
                    deserializedVirtualNetworkConfiguration.enginePublicIpId = reader.getString();
                    continue;
                }
                if ("dataManagementPublicIpId".equals(fieldName)) {
                    deserializedVirtualNetworkConfiguration.dataManagementPublicIpId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedVirtualNetworkConfiguration.state = VnetState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkConfiguration;
        });
    }
}

