/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.kusto.models.AzureCapacity;
import com.azure.resourcemanager.kusto.models.AzureSku;
import java.io.IOException;

public final class AzureResourceSkuInner
implements JsonSerializable<AzureResourceSkuInner> {
    private String resourceType;
    private AzureSku sku;
    private AzureCapacity capacity;

    public String resourceType() {
        return this.resourceType;
    }

    public AzureResourceSkuInner withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public AzureSku sku() {
        return this.sku;
    }

    public AzureResourceSkuInner withSku(AzureSku sku) {
        this.sku = sku;
        return this;
    }

    public AzureCapacity capacity() {
        return this.capacity;
    }

    public AzureResourceSkuInner withCapacity(AzureCapacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static AzureResourceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (AzureResourceSkuInner)jsonReader.readObject(reader -> {
            AzureResourceSkuInner deserializedAzureResourceSkuInner = new AzureResourceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedAzureResourceSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedAzureResourceSkuInner.sku = AzureSku.fromJson(reader);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedAzureResourceSkuInner.capacity = AzureCapacity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureResourceSkuInner;
        });
    }
}

